/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class BMC12In1
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int reg0;
    private int reg1;
    private int mode;

    public BMC12In1(CartFile cartFile) {
        super(cartFile, 4, 2);
    }

    @Override
    public void init() {
        this.updateBanks();
    }

    private void updateBanks() {
        int bank = (this.mode & 3) << 3;
        this.setChrBank(0, this.reg0 >> 3 | bank << 2);
        this.setChrBank(1, this.reg1 >> 3 | bank << 2);
        if (BitUtil.getBitBool(this.mode, 3)) {
            this.setPrgBanks(2, 2, bank | this.reg0 & 6);
        } else {
            this.setPrgBank(2, bank | this.reg0 & 7);
            this.setPrgBank(3, bank | 7);
        }
        this.setNametableMirroring(BitUtil.getBit(this.mode, 2));
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xE000) {
            case 40960: {
                this.reg0 = value;
                this.updateBanks();
                break;
            }
            case 49152: {
                this.reg1 = value;
                this.updateBanks();
                break;
            }
            case 57344: {
                this.mode = value & 0xF;
                this.updateBanks();
            }
        }
    }
}

