/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.txc;

import nintaco.files.CartFile;
import nintaco.mappers.txc.TxcLatch;

public class Txc22211C
extends TxcLatch {
    private static final long serialVersionUID = 0L;
    private boolean ppuDisabled;

    public Txc22211C(CartFile cartFile) {
        super(cartFile, 2, 1);
    }

    @Override
    public void init() {
        super.init();
        this.ppuDisabled = false;
    }

    @Override
    protected void updateState() {
        this.setPrgBank(0);
        if (this.chrRomLength >= 16384) {
            this.ppuDisabled = false;
            this.setChrBank((this.output & 2) << 1 | (this.Y ? 2 : 0) | this.output & 1);
        } else if (this.Y) {
            this.ppuDisabled = false;
            this.setChrBank(0);
        } else {
            this.ppuDisabled = true;
        }
    }

    @Override
    public int readVRAM(int address) {
        return this.ppuDisabled ? 255 : super.readVRAM(address);
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (!this.ppuDisabled) {
            super.writeVRAM(address, value);
        }
    }

    @Override
    public int readMemory(int address) {
        return (address & 0xE000) == 16384 ? 0xF0 | this.readLatch(address) & 0xF : super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address >= 16384) {
            this.writeLatch(address, value & 0xF);
        } else {
            this.memory[address] = value;
        }
    }
}

