/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.sunsoft.fme7;

import nintaco.mappers.Audio;
import nintaco.mappers.sunsoft.fme7.Emu2149;
import nintaco.mappers.sunsoft.fme7.PSG;
import nintaco.tv.TVSystem;

public final class Sunsoft5BAudio
extends Audio {
    private static final long serialVersionUID = 0L;
    private static final double RATE = 48000.0;
    private static final int MIX_RANGE = 2048;
    private static float volume;
    private PSG psg;
    private float divider;
    private float dividerStep;
    private int soundSample;
    private TVSystem tvSystem;

    public static void setVolume(int volume) {
        Sunsoft5BAudio.volume = (float)volume / 100.0f;
    }

    @Override
    public void init() {
    }

    @Override
    public void reset() {
        this.tvSystemChanged();
    }

    public void setTVSystem(TVSystem tvSystem) {
        if (this.tvSystem != tvSystem) {
            this.tvSystem = tvSystem;
            this.tvSystemChanged();
        }
    }

    private void tvSystemChanged() {
        this.divider = 0.0f;
        this.soundSample = 0;
        if (this.tvSystem == null) {
            this.tvSystem = TVSystem.NTSC;
        }
        double cyclesPerSecond = this.tvSystem.getCyclesPerSecond();
        this.dividerStep = (float)(cyclesPerSecond / 48000.0);
        this.psg = Emu2149.PSG_new((int)cyclesPerSecond, 48000);
        for (int i = 0; i < 16; ++i) {
            this.writeRegister(49152, i);
            this.writeRegister(57344, 0);
        }
        this.writeRegister(49152, 7);
        this.writeRegister(57344, 63);
        Emu2149.PSG_set_quality(this.psg, true);
        Emu2149.PSG_reset(this.psg);
    }

    @Override
    public boolean writeRegister(int address, int value) {
        switch (address & 0xE000) {
            case 49152: {
                this.writeAudioRegisterIndex(value);
                return true;
            }
            case 57344: {
                this.writeAudioRegisterValue(value);
                return true;
            }
        }
        return false;
    }

    private void writeAudioRegisterIndex(int value) {
        Emu2149.PSG_writeIO(this.psg, 0, value);
    }

    private void writeAudioRegisterValue(int value) {
        Emu2149.PSG_writeIO(this.psg, 1, value);
    }

    @Override
    public void update() {
        while (true) {
            float f;
            this.divider += 1.0f;
            if (!(f >= this.dividerStep)) break;
            this.divider -= this.dividerStep;
            this.soundSample = Emu2149.PSG_calc(this.psg) << 3;
        }
    }

    @Override
    public int getAudioMixerScale() {
        return 63487;
    }

    @Override
    public float getAudioSample() {
        return volume * (float)this.soundSample;
    }

    static {
        Sunsoft5BAudio.setVolume(100);
    }
}

