/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.sunsoft.fme7;

import nintaco.mappers.sunsoft.fme7.PSG;

public final class Emu2149 {
    private static final int EMU2149_VOL_DEFAULT = 1;
    private static final int EMU2149_VOL_YM2149 = 0;
    private static final int EMU2149_VOL_AY_3_8910 = 1;
    private static final int[][] voltbl = new int[][]{{0, 1, 1, 2, 2, 3, 3, 4, 5, 6, 7, 9, 11, 13, 15, 18, 22, 26, 31, 37, 45, 53, 63, 76, 90, 106, 127, 151, 180, 214, 235, 255}, {0, 0, 1, 1, 2, 2, 3, 3, 5, 5, 7, 7, 11, 11, 15, 15, 22, 22, 31, 31, 45, 45, 63, 63, 90, 90, 127, 127, 180, 180, 255, 255}};
    private static final int GETA_BITS = 24;

    private static int PSG_MASK_CH(int x) {
        return 1 << x;
    }

    private static void internal_refresh(PSG psg) {
        if (psg.quality) {
            psg.base_incr = 0x1000000;
            psg.realstep = (int)(0x80000000L / (long)psg.rate);
            psg.psgstep = (int)(0x80000000L / (long)(psg.clk / 16));
            psg.psgtime = 0;
        } else {
            psg.base_incr = (int)((double)psg.clk * 1.6777216E7 / (double)(16 * psg.rate));
        }
    }

    public static final void PSG_set_rate(PSG psg, int r) {
        psg.rate = r != 0 ? r : 44100;
        Emu2149.internal_refresh(psg);
    }

    public static final void PSG_set_quality(PSG psg, boolean q) {
        psg.quality = q;
        Emu2149.internal_refresh(psg);
    }

    public static final PSG PSG_new(int c, int r) {
        PSG psg = new PSG();
        Emu2149.PSG_setVolumeMode(psg, 1);
        psg.clk = c;
        psg.rate = r != 0 ? r : 44100;
        Emu2149.PSG_set_quality(psg, false);
        return psg;
    }

    public static final void PSG_setVolumeMode(PSG psg, int type) {
        switch (type) {
            case 1: {
                psg.voltbl = voltbl[0];
                break;
            }
            case 2: {
                psg.voltbl = voltbl[1];
                break;
            }
            default: {
                psg.voltbl = voltbl[1];
            }
        }
    }

    public static final int PSG_setMask(PSG psg, int mask) {
        int ret = 0;
        if (psg != null) {
            ret = psg.mask;
            psg.mask = mask;
        }
        return ret;
    }

    public static final int PSG_toggleMask(PSG psg, int mask) {
        int ret = 0;
        if (psg != null) {
            ret = psg.mask;
            psg.mask ^= mask;
        }
        return ret;
    }

    public static final void PSG_reset(PSG psg) {
        int i;
        psg.base_count = 0;
        for (i = 0; i < 3; ++i) {
            psg.cout[i] = 0;
            psg.count[i] = 4096;
            psg.freq[i] = 0;
            psg.edge[i] = false;
            psg.volume[i] = 0;
        }
        psg.mask = 0;
        for (i = 0; i < 16; ++i) {
            psg.reg[i] = 0;
        }
        psg.adr = 0;
        psg.noise_seed = 65535;
        psg.noise_count = 64;
        psg.noise_freq = 0;
        psg.env_volume = 0;
        psg.env_ptr = 0;
        psg.env_freq = 0;
        psg.env_count = 0;
        psg.env_pause = true;
        psg.out = 0;
    }

    public static final void PSG_delete(PSG psg) {
    }

    public static final int PSG_readIO(PSG psg) {
        return psg.reg[psg.adr];
    }

    public static final int PSG_readReg(PSG psg, int reg) {
        return psg.reg[reg & 0x1F];
    }

    public static final void PSG_writeIO(PSG psg, int adr, int val) {
        if ((adr & 1) != 0) {
            Emu2149.PSG_writeReg(psg, psg.adr, val);
        } else {
            psg.adr = val & 0x1F;
        }
    }

    private static final int calc(PSG psg) {
        int mix = 0;
        psg.base_count += psg.base_incr;
        int incr = psg.base_count >> 24;
        psg.base_count &= 0xFFFFFF;
        psg.env_count += incr;
        while (psg.env_count >= 65536 && psg.env_freq != 0) {
            if (!psg.env_pause) {
                psg.env_ptr = psg.env_face ? psg.env_ptr + 1 & 0x3F : psg.env_ptr + 63 & 0x3F;
            }
            if ((psg.env_ptr & 0x20) != 0) {
                if (psg.env_continue) {
                    if (psg.env_alternate ^ psg.env_hold) {
                        psg.env_face ^= true;
                    }
                    if (psg.env_hold) {
                        psg.env_pause = true;
                    }
                    psg.env_ptr = psg.env_face ? 0 : 31;
                } else {
                    psg.env_pause = true;
                    psg.env_ptr = 0;
                }
            }
            psg.env_count -= psg.env_freq;
        }
        psg.noise_count += incr;
        if ((psg.noise_count & 0x40) != 0) {
            if ((psg.noise_seed & 1) != 0) {
                psg.noise_seed ^= 0x24000;
            }
            psg.noise_seed >>= 1;
            psg.noise_count -= psg.noise_freq;
        }
        boolean noise = (psg.noise_seed & 1) != 0;
        for (int i = 0; i < 3; ++i) {
            int n = i;
            psg.count[n] = psg.count[n] + incr;
            if ((psg.count[i] & 0x1000) != 0) {
                if (psg.freq[i] > 1) {
                    psg.edge[i] = !psg.edge[i];
                    int n2 = i;
                    psg.count[n2] = psg.count[n2] - psg.freq[i];
                } else {
                    psg.edge[i] = true;
                }
            }
            psg.cout[i] = 0;
            if ((psg.mask & Emu2149.PSG_MASK_CH(i)) != 0 || !psg.tmask[i] && !psg.edge[i] || !psg.nmask[i] && !noise) continue;
            psg.cout[i] = (psg.volume[i] & 0x20) == 0 ? psg.voltbl[psg.volume[i] & 0x1F] : psg.voltbl[psg.env_ptr];
            mix += psg.cout[i];
        }
        return mix;
    }

    public static final int PSG_calc(PSG psg) {
        if (!psg.quality) {
            return Emu2149.calc(psg) << 4;
        }
        while (psg.realstep > psg.psgtime) {
            psg.psgtime += psg.psgstep;
            psg.out += Emu2149.calc(psg);
            psg.out >>= 1;
        }
        psg.psgtime -= psg.realstep;
        return psg.out << 4;
    }

    public static final void PSG_writeReg(PSG psg, int reg, int val) {
        if (reg > 15) {
            return;
        }
        psg.reg[reg] = val & 0xFF;
        switch (reg) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                int c = reg >> 1;
                psg.freq[c] = ((psg.reg[c * 2 + 1] & 0xF) << 8) + psg.reg[c * 2];
                break;
            }
            case 6: {
                psg.noise_freq = val == 0 ? 1 : (val & 0x1F) << 1;
                break;
            }
            case 7: {
                psg.tmask[0] = (val & 1) != 0;
                psg.tmask[1] = (val & 2) != 0;
                psg.tmask[2] = (val & 4) != 0;
                psg.nmask[0] = (val & 8) != 0;
                psg.nmask[1] = (val & 0x10) != 0;
                psg.nmask[2] = (val & 0x20) != 0;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                psg.volume[reg - 8] = val << 1;
                break;
            }
            case 11: 
            case 12: {
                psg.env_freq = (psg.reg[12] << 8) + psg.reg[11];
                break;
            }
            case 13: {
                psg.env_continue = (val >> 3 & 1) != 0;
                psg.env_attack = (val >> 2 & 1) != 0;
                psg.env_alternate = (val >> 1 & 1) != 0;
                psg.env_hold = (val & 1) != 0;
                psg.env_face = psg.env_attack;
                psg.env_pause = false;
                psg.env_count = 65536 - psg.env_freq;
                psg.env_ptr = psg.env_face ? 0 : 31;
            }
        }
    }

    private Emu2149() {
    }
}

