/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.sunsoft;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Sunsoft3
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int irqCounter;
    private boolean irqWriteLow;
    private boolean irqEnabled;

    public Sunsoft3(CartFile cartFile) {
        super(cartFile, 4, 4);
    }

    @Override
    public void init() {
        this.setPrgBank(3, -1);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xF800) {
            case 34816: {
                this.setChrBank(0, value);
                break;
            }
            case 38912: {
                this.setChrBank(1, value);
                break;
            }
            case 43008: {
                this.setChrBank(2, value);
                break;
            }
            case 47104: {
                this.setChrBank(3, value);
                break;
            }
            case 51200: {
                this.writeIrqLoad(value);
                break;
            }
            case 55296: {
                this.writeIrqEnable(value);
                break;
            }
            case 59392: {
                this.setNametableMirroring(value);
                break;
            }
            case 63488: {
                this.setPrgBank(2, value);
            }
        }
    }

    private void writeIrqLoad(int value) {
        this.irqCounter = this.irqWriteLow ? this.irqCounter & 0xFF00 | value : value << 8 | this.irqCounter & 0xFF;
        this.irqWriteLow = !this.irqWriteLow;
    }

    private void writeIrqEnable(int value) {
        this.irqEnabled = BitUtil.getBitBool(value, 4);
        this.cpu.setMapperIrq(false);
        this.irqWriteLow = false;
    }

    @Override
    public void update() {
        if (this.irqEnabled) {
            this.irqCounter = this.irqCounter - 1 & 0xFFFF;
            if (this.irqCounter == 65535) {
                this.cpu.setMapperIrq(true);
                this.irqEnabled = false;
            }
        }
    }
}

