/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.racermate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.preferences.GamePrefs;

public class RacerMate
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int CLOCKS_PER_IRQ = 1024;
    private int irqCounter = 1024;
    private boolean irqEnabled;

    public RacerMate(CartFile cartFile) {
        super(cartFile, 4, 2);
    }

    @Override
    protected int getChrRamSize(CartFile cartFile) {
        return 65536;
    }

    @Override
    public void init() {
        this.setPrgBank(3, -1);
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address < 49152) {
            this.writeBankSelect(value);
        } else {
            this.writeIrqAcknowledge(address);
        }
    }

    private void writeBankSelect(int value) {
        this.setPrgBank(2, value >> 6);
        this.setChrBank(1, value & 0xF);
    }

    private void writeIrqAcknowledge(int address) {
        if (address == 61568) {
            this.irqEnabled = false;
            this.irqCounter = 1024;
            this.cpu.setMapperIrq(false);
        } else if (address == 61440) {
            this.irqEnabled = true;
        }
    }

    @Override
    public void update() {
        if (this.irqEnabled && --this.irqCounter == 0) {
            this.cpu.setMapperIrq(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadNonVolatilePrgRam() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            int[] sram = GamePrefs.getInstance().getNonVolatilePrgRam();
            if (sram != null && sram.length == 65536) {
                System.arraycopy(sram, 0, this.xChrRam, 0, 65536);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveNonVolatilePrgRam() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            GamePrefs prefs = GamePrefs.getInstance();
            int[] sram = prefs.getNonVolatilePrgRam();
            if (sram == null || sram.length != 65536) {
                sram = new int[65536];
            }
            System.arraycopy(this.xChrRam, 0, sram, 0, 65536);
            prefs.setNonVolatilePrgRam(sram);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            GamePrefs.save();
            return;
        }
    }
}

