/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pyramid;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class PEC586
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int[] BankLUT = new int[]{3, 19, 35, 51, 3, 19, 35, 51, 3, 19, 35, 51, 3, 19, 35, 51, 69, 103, 69, 103, 69, 103, 69, 103, 69, 103, 69, 103, 69, 103, 69, 103, 3, 19, 35, 51, 3, 19, 35, 51, 3, 19, 35, 51, 3, 19, 35, 51, 71, 103, 71, 103, 71, 103, 71, 103, 71, 103, 71, 103, 71, 103, 71, 103, 2, 18, 34, 50, 2, 18, 34, 50, 2, 18, 34, 50, 2, 18, 34, 50, 69, 103, 69, 103, 69, 103, 69, 103, 69, 103, 69, 103, 69, 103, 69, 103, 2, 18, 34, 50, 2, 18, 34, 50, 2, 18, 34, 50, 0, 16, 32, 48, 71, 103, 71, 103, 71, 103, 71, 103, 71, 103, 71, 103, 71, 103, 71, 103};
    private static final int[] ProtLUT = new int[]{0, 9, 0, 0, 0, 0, 0, 32, 4, 0, 0, 0, 0, 0, 0, 2};
    private final boolean is512KPrgROM;
    private int mode;
    private int index;
    private int read5300;
    private int lastNTAddress;

    public PEC586(CartFile cartFile) {
        super(cartFile, 4, 1);
        this.is512KPrgROM = this.prgRomLength == 524288;
    }

    @Override
    public void init() {
        this.index = 0;
        this.mode = this.is512KPrgROM ? 0 : 14;
        this.updateState();
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            if ((this.mode & 0x80) != 0) {
                return super.readVRAM(address & 0xFF7 | (this.lastNTAddress & 0x201) << 3);
            }
        } else if (address < 16128 && (address & 0x3FF) < 960) {
            this.lastNTAddress = address;
        }
        return super.readVRAM(address);
    }

    @Override
    public int readMemory(int address) {
        if (address >= 32768) {
            if (this.is512KPrgROM && (this.mode & 0x10) == 0 && ((this.mode & 0x40) == 0 || address >= 40960)) {
                return this.prgROM[0x41C00 | address << 3 & 0x3E000 | address & 0x3FF];
            }
        } else {
            switch (address & 0xF700) {
                case 21248: {
                    this.read5300 ^= 4;
                    return this.read5300;
                }
                case 21760: {
                    return 0xD8 | ProtLUT[this.index >> 4];
                }
            }
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        switch (address & 0xF700) {
            case 20480: {
                this.mode = value;
                this.updateState();
                break;
            }
            case 21504: {
                this.index = value;
                this.updateState();
                break;
            }
            default: {
                this.memory[address] = value;
            }
        }
    }

    private void updateState() {
        if (this.is512KPrgROM) {
            this.set2PrgBanks(2, (this.mode & 7) << 1);
            if (BitUtil.getBitBool(this.mode, 6) && !BitUtil.getBitBool(this.mode, 4)) {
                this.setPrgBank(2, 0x20 | (this.mode & 0x20) >> 1 | this.mode & 0xF);
            }
            this.setNametableMirroring((this.mode & 0x18) == 24 ? 1 : 0);
        } else {
            int bank = BankLUT[this.mode & 0x7F];
            this.setPrgBank(2, bank >> 4);
            this.setPrgBank(3, bank & 0xF);
            this.setNametableMirroring(0);
        }
    }
}

