/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class Mapper334
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private int prgRomBank;
    private int dip;

    public Mapper334(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void resetting() {
        this.dip ^= 1;
    }

    @Override
    protected void updatePrgBanks() {
        this.set4PrgBanks(4, this.prgRomBank);
    }

    private void writePrgRomBank(int value) {
        this.prgRomBank = (value & 6) << 1;
        this.updateBanks();
    }

    @Override
    public int readMemory(int address) {
        if (address == 24578) {
            return this.dip;
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xE001) == 24576) {
            this.writePrgRomBank(value);
        }
        super.writeMemory(address, value);
    }
}

