/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class Mapper254
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private int xorMask;
    private boolean applyXorMask = true;

    public Mapper254(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public int readMemory(int address) {
        int value = super.readMemory(address);
        if (this.applyXorMask && (address & 0xE000) == 24576) {
            return value ^ this.xorMask;
        }
        return value;
    }

    @Override
    public void writeRegister(int address, int value) {
        switch (address) {
            case 32768: {
                this.applyXorMask = false;
                break;
            }
            case 40961: {
                this.xorMask = value;
            }
        }
        super.writeRegister(address, value);
    }
}

