/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper199
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[]{-2, -1, 1, 3};
    private final boolean[] chrRamBanks = new boolean[8];
    private int bankSelect;

    public Mapper199(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192 && this.chrAddressMask != 0) {
            return (this.chrRamBanks[address >> this.chrShift] ? this.vram : this.chrROM)[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRomSizeMask];
        }
        return this.vram[address];
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (address < 8192 && this.chrAddressMask != 0) {
            if (this.chrRamBanks[address >> this.chrShift]) {
                this.vram[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRomSizeMask] = value;
            }
        } else {
            this.vram[address] = value;
        }
    }

    @Override
    protected void writeBankSelect(int value) {
        super.writeBankSelect(value);
        this.bankSelect = value;
    }

    @Override
    protected void writeBankData(int value) {
        if (BitUtil.getBitBool(this.bankSelect, 3)) {
            this.regs[this.bankSelect & 3] = value;
        } else {
            this.R[this.register] = value;
        }
        this.updateBanks();
    }

    @Override
    protected void writeMirroring(int value) {
        this.setNametableMirroring(value & 3);
    }

    @Override
    protected void updatePrgBanks() {
        super.updatePrgBanks();
        this.setPrgBank(6, this.regs[0]);
        this.setPrgBank(7, this.regs[1]);
    }

    @Override
    protected void setChrBank(int bank, int value) {
        super.setChrBank(bank, value);
        super.setChrBank(0, this.R[0]);
        super.setChrBank(1, this.regs[2]);
        super.setChrBank(2, this.R[1]);
        super.setChrBank(3, this.regs[3]);
        this.chrRamBanks[bank] = value < 8;
        this.chrRamBanks[0] = this.R[0] < 8;
        this.chrRamBanks[1] = this.regs[2] < 8;
        this.chrRamBanks[2] = this.R[1] < 8;
        this.chrRamBanks[3] = this.regs[3] < 8;
    }
}

