/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class BMCL6IN1
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private boolean mmc3Banking;
    private boolean mmc3Mirroring;
    private int mirroring;
    private int bank;

    public BMCL6IN1(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.writeOuterBankAndMode(0);
    }

    private void writeOuterBankAndMode(int value) {
        this.bank = (value & 3) << 2;
        this.mmc3Banking = (value & 0xC) != 0;
        this.setPrgBlock((value & 0xC0) >> 2, 15);
        boolean bl = this.mmc3Mirroring = !BitUtil.getBitBool(value, 5);
        if (this.mmc3Mirroring) {
            this.writeMirroring(this.mirroring);
        } else {
            this.setNametableMirroring(BitUtil.getBitBool(value, 4) ? 3 : 2);
        }
    }

    @Override
    protected void updatePrgBanks() {
        if (this.mmc3Banking) {
            super.updatePrgBanks();
        } else {
            this.set4PrgBanks(4, this.bank);
        }
    }

    @Override
    protected void writeMirroring(int value) {
        this.mirroring = value;
        if (this.mmc3Mirroring) {
            super.writeMirroring(value);
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        super.writeMemory(address, value);
        if (this.prgRamWritesEnabled && this.prgRamChipEnabled && (address & 0xE000) == 24576) {
            this.writeOuterBankAndMode(value);
        }
    }
}

