/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class BMCGN26
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private boolean mmc3Mode;
    private boolean openBus;
    private boolean dip;

    public BMCGN26(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.openBus = false;
        this.mmc3Mode = false;
        this.writeOuterBankAndMode(0);
    }

    @Override
    public void resetting() {
        this.init();
    }

    public void writeOuterBankAndMode(int address) {
        this.setChrBlock((address & 3) << 7, 255);
        int outer = (address & 3) - 1;
        if (outer < 0) {
            outer = 0;
        }
        boolean bl = this.mmc3Mode = !BitUtil.getBitBool(address, 2);
        if (BitUtil.getBitBool(address, 3)) {
            this.openBus = this.dip;
            this.dip ^= true;
        } else {
            this.openBus = false;
            this.setPrgBlock(outer << 4, 15);
        }
    }

    @Override
    protected void updatePrgBanks() {
        if (this.mmc3Mode) {
            super.updatePrgBanks();
        } else {
            this.set4PrgBanks(4, this.R[6] & 0xFC);
        }
    }

    @Override
    public int readMemory(int address) {
        return this.openBus && address >= 32768 ? 255 : super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        if (this.prgRamWritesEnabled && this.prgRamChipEnabled && (address & 0xE000) == 24576) {
            this.writeOuterBankAndMode(address);
        }
        super.writeMemory(address, value);
    }
}

