/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import java.util.Arrays;
import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class _3D_Block
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int PHASE_NONE = 0;
    private static final int PHASE_RAISE = 1;
    private static final int PHASE_HOLD = 2;
    private static final int PHASE_RELEASE = 3;
    private int PICCounter;
    private int LastPICAddress;
    private int LastFunction;
    private int irqsToRaise;
    private int irqRaiseCount;
    private int irqHoldCount;
    private int irqReleaseCountOdd;
    private int irqReleaseCountEven;
    private int irqCounter;
    private int irqPhase;
    private int maxCounter;
    private int _3dLatchBits;
    private int _3dLatch;
    private int _3dCounter;
    private int[] bfRAM = new int[32];
    private int bfAddr;
    private int bfLatch;
    private int _3dX;
    private int _3dY;
    private int _3dZ;
    private int _3dMinZ;
    private int _3dHitGround;
    private int _3dNewZ;
    private int _3dNewY;
    private int _3dNewX;
    private int _3dMaxZ;
    private int _3dMinY;
    private int _3dMaxY;
    private int _3dMinX;
    private int _3dMaxX;
    private int _3dCommand;
    private int byte2DD;
    private int byte2DE;
    private int byte2E1;
    private int byte2E2;
    private int byte2E5;
    private int byte2E6;

    public _3D_Block(CartFile cartFile) {
        super(cartFile, 1, 1);
    }

    @Override
    public void init() {
        Arrays.fill(this.bfRAM, 0);
        this.bfRAM[26] = 2;
        this.bfRAM[28] = 5;
        this.bfRAM[29] = 6;
        this.maxCounter = 0;
        this.irqPhase = 0;
        this.irqCounter = 0;
        this.irqReleaseCountEven = 0;
        this.irqReleaseCountOdd = 0;
        this.irqHoldCount = 0;
        this.irqRaiseCount = 0;
        this.irqsToRaise = 0;
        this._3dLatch = 0;
        this.LastPICAddress = 0;
        this.PICCounter = 0;
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void _3dUp() {
        if (this._3dY > this._3dMinY) {
            --this._3dY;
        }
    }

    private void _3dDown() {
        if (this._3dY < this._3dMaxY) {
            ++this._3dY;
        }
    }

    private void _3dLeft() {
        if (this._3dX > this._3dMinX) {
            --this._3dX;
        }
    }

    private void _3dRight() {
        if (this._3dX < this._3dMaxX) {
            ++this._3dX;
        }
    }

    private int _3dGetMin(int val) {
        return (val & 7) == 0 ? 2 : ((val & 1) != 0 ? 1 : 0);
    }

    private int _3dGetMax(int val) {
        return (val & 7) == 2 ? 5 : ((val & 7) == 3 ? 4 : 3);
    }

    private void _3dProcess() {
        int byte1 = this._3dLatch >> 24 & 0xFF;
        int byte2 = this._3dLatch >> 16 & 0xFF;
        int byte3 = this._3dLatch >> 8 & 0xFF;
        int byte4 = this._3dLatch & 0xFF;
        this.byte2E1 = byte1 >> 3 & 7;
        this.byte2DD = byte1 >> 6 & 3;
        this.byte2DE = byte1 & 7;
        this.byte2E6 = byte2 >> 3 & 7;
        this.byte2E2 = byte2 >> 6 & 3 | (byte3 & 8) >> 1;
        this.byte2E5 = byte2 & 7;
        this._3dZ = byte3 >> 4 & 0xF;
        this._3dX = byte3 & 7;
        this._3dY = byte4 >> 5;
        this._3dCommand = byte4 & 0x1F;
        int n = (this.byte2DD & 3) == 0 ? 2 : (this._3dMinZ = (this.byte2DD & 1) != 0 ? 1 : 0);
        this._3dMaxZ = (this.byte2E2 & 3) == 0 ? 8 : ((this.byte2E2 & 1) != 0 ? 9 : 10);
        this._3dMinX = this._3dGetMin(this.byte2E1);
        this._3dMinY = this._3dGetMin(this.byte2DE);
        this._3dMaxX = this._3dGetMax(this.byte2E6);
        this._3dMaxY = this._3dGetMax(this.byte2E5);
        switch (this._3dCommand & 0x1F) {
            case 8: {
                ++this._3dZ;
                break;
            }
            case 16: {
                this._3dUp();
                break;
            }
            case 17: {
                this._3dUp();
                this._3dRight();
                break;
            }
            case 18: {
                this._3dRight();
                break;
            }
            case 19: {
                this._3dRight();
                this._3dDown();
                break;
            }
            case 20: {
                this._3dDown();
                break;
            }
            case 21: {
                this._3dDown();
                this._3dLeft();
                break;
            }
            case 22: {
                this._3dLeft();
                break;
            }
            case 23: {
                this._3dLeft();
                this._3dUp();
            }
        }
        if (this._3dZ < this._3dMinZ) {
            this._3dHitGround = 0;
            this._3dNewZ = this._3dMinZ;
        } else if (this._3dZ >= this._3dMaxZ) {
            this._3dHitGround = 1;
            this._3dNewZ = this._3dMaxZ;
        } else {
            this._3dHitGround = 0;
            this._3dNewZ = this._3dZ;
        }
        this._3dNewX = this._3dX < this._3dMinX ? this._3dMinX : (this._3dX >= this._3dMaxX ? this._3dMaxX : this._3dX);
        this._3dNewY = this._3dY < this._3dMinY ? this._3dMinY : (this._3dY >= this._3dMaxY ? this._3dMaxY : this._3dY);
        this._3dLatch = this._3dHitGround << 24 | this._3dNewY << 16 | this._3dNewX << 8 | this._3dNewZ;
    }

    private void CheckAddress(int Addr) {
        int PICAddress = Addr >> 4;
        if (PICAddress == this.LastPICAddress) {
            ++this.PICCounter;
        } else {
            this.PICCounter = 0;
            this.LastFunction = 255;
        }
        this.LastPICAddress = PICAddress;
        if (this.PICCounter == 100 && PICAddress >= 4064 && PICAddress <= 4079) {
            int PICFNum = PICAddress & 0xF;
            if (PICFNum != this.LastFunction) {
                switch (PICFNum) {
                    case 8: {
                        this.bfAddr = 0;
                        break;
                    }
                    case 9: {
                        ++this.bfAddr;
                        this.bfAddr &= 0x1F;
                        break;
                    }
                    case 10: {
                        this.bfRAM[this.bfAddr] = 0;
                        break;
                    }
                    case 11: {
                        int n = this.bfAddr;
                        this.bfRAM[n] = this.bfRAM[n] + 1;
                        int n2 = this.bfAddr;
                        this.bfRAM[n2] = this.bfRAM[n2] & 0xFF;
                        break;
                    }
                    case 12: {
                        this.irqPhase = 1;
                        this.irqRaiseCount = 25000;
                        this.irqHoldCount = 24;
                        this.irqReleaseCountEven = 1;
                        this.irqReleaseCountOdd = 1;
                        this.irqsToRaise = 1;
                        this.irqCounter = 0;
                        break;
                    }
                    case 13: {
                        int bfHighScore = this.bfRAM[26] + this.bfRAM[27] * 10 + this.bfRAM[28] * 100 + this.bfRAM[29] * 1000 + this.bfRAM[30] * 10000 + this.bfRAM[31] * 100000;
                        int bfPlayerScore = this.bfRAM[20] + this.bfRAM[21] * 10 + this.bfRAM[22] * 100 + this.bfRAM[23] * 1000 + this.bfRAM[24] * 10000 + this.bfRAM[25] * 100000;
                        if (bfPlayerScore <= bfHighScore) break;
                        System.arraycopy(this.bfRAM, 20, this.bfRAM, 26, 6);
                        break;
                    }
                    case 14: {
                        this.bfLatch = this.bfRAM[this.bfAddr];
                        break;
                    }
                    case 15: {
                        --this.bfLatch;
                        this.bfLatch &= 0xFF;
                        if (this.bfLatch != 0) break;
                        this.irqPhase = 1;
                        this.irqHoldCount = 24;
                        this.irqReleaseCountEven = 1;
                        this.irqReleaseCountOdd = 1;
                        this.irqsToRaise = 1;
                        this.irqRaiseCount = 1;
                        this.irqCounter = 0;
                    }
                }
            }
            this.LastFunction = PICFNum;
        } else if (this.PICCounter == 100 && PICAddress >= 3608 && PICAddress <= 3615) {
            int PICFNum = PICAddress & 7;
            if (PICFNum != this.LastFunction) {
                switch (PICFNum) {
                    case 0: {
                        this.irqPhase = 1;
                        this.irqRaiseCount = 12400;
                        this.irqHoldCount = 24;
                        this.irqReleaseCountEven = 1;
                        this.irqReleaseCountOdd = 1;
                        this.irqsToRaise = 1;
                        this.irqCounter = 0;
                        break;
                    }
                    case 4: {
                        this.irqPhase = 1;
                        this.irqRaiseCount = 3182;
                        this.irqHoldCount = 24;
                        this.irqReleaseCountEven = 1794;
                        this.irqReleaseCountOdd = 1794;
                        this.irqsToRaise = 10;
                        this.irqCounter = 0;
                        break;
                    }
                    case 1: {
                        this._3dLatch = 0;
                        this._3dLatchBits = 0;
                        this.irqPhase = 1;
                        this.irqRaiseCount = 1;
                        this.irqHoldCount = 24;
                        this.irqReleaseCountEven = 1;
                        this.irqReleaseCountOdd = 1;
                        this.irqsToRaise = 1;
                        this.irqCounter = 0;
                        break;
                    }
                    case 3: {
                        this._3dLatch = this._3dLatch << 1 | 1;
                        ++this._3dLatchBits;
                        if (this._3dLatchBits == 32) {
                            this._3dProcess();
                        }
                        this.irqPhase = 1;
                        this.irqRaiseCount = 1;
                        this.irqHoldCount = 24;
                        this.irqReleaseCountEven = 1;
                        this.irqReleaseCountOdd = 1;
                        this.irqsToRaise = 1;
                        this.irqCounter = 0;
                        break;
                    }
                    case 5: {
                        this._3dLatch <<= 1;
                        ++this._3dLatchBits;
                        if (this._3dLatchBits == 32) {
                            this._3dProcess();
                        }
                        this.irqPhase = 1;
                        this.irqRaiseCount = 1;
                        this.irqHoldCount = 24;
                        this.irqReleaseCountEven = 1;
                        this.irqReleaseCountOdd = 1;
                        this.irqsToRaise = 1;
                        this.irqCounter = 0;
                        break;
                    }
                    case 6: {
                        this.irqsToRaise = this._3dLatch & 0xFF;
                        this._3dLatch >>= 8;
                        if (this.irqsToRaise != 0) {
                            this.irqPhase = 1;
                            this.irqRaiseCount = 1;
                            this.irqHoldCount = 24;
                            this.irqReleaseCountEven = 24;
                            this.irqReleaseCountOdd = 24;
                        }
                        this.irqCounter = 0;
                        break;
                    }
                    case 7: {
                        this.irqPhase = 0;
                        this._3dCounter = 83;
                        this.irqCounter = 0;
                        break;
                    }
                    case 2: {
                        if (this._3dCounter <= 0) break;
                        this.maxCounter = 28316;
                        this.irqPhase = 1;
                        this.irqRaiseCount = 7216;
                        this.irqHoldCount = 24;
                        this.irqReleaseCountEven = 341 * this._3dCounter / 6 - 24;
                        this.irqReleaseCountOdd = 1794;
                        this.irqsToRaise = 64;
                        --this._3dCounter;
                        this.irqCounter = 0;
                    }
                }
            }
            this.LastFunction = PICFNum;
        }
    }

    @Override
    public int readMemory(int address) {
        if (address >= 32768) {
            this.CheckAddress(address);
        }
        return super.readMemory(address);
    }

    @Override
    public void writeRegister(int address, int value) {
        this.CheckAddress(address);
    }

    @Override
    public void update() {
        if (this.maxCounter != 0 && --this.maxCounter == 0) {
            this.cpu.setMapperIrq(false);
            this.irqPhase = 0;
            if ((this.irqsToRaise & 1) != 0) {
                this.irqPhase = 1;
                this.irqsToRaise = 1;
                this.irqCounter = this.irqRaiseCount - 5;
            }
        }
        switch (this.irqPhase) {
            case 1: {
                if (++this.irqCounter != this.irqRaiseCount) break;
                this.cpu.setMapperIrq(true);
                this.irqPhase = 2;
                this.irqCounter = 0;
                break;
            }
            case 2: {
                if (++this.irqCounter != this.irqHoldCount) break;
                this.cpu.setMapperIrq(false);
                this.irqPhase = 3;
                this.irqCounter = 0;
                break;
            }
            case 3: {
                if (++this.irqCounter != ((this.irqsToRaise & 1) != 0 ? this.irqReleaseCountOdd : this.irqReleaseCountEven)) break;
                if (--this.irqsToRaise != 0) {
                    this.irqPhase = 2;
                    this.cpu.setMapperIrq(true);
                } else {
                    this.irqPhase = 0;
                }
                this.irqCounter = 0;
            }
        }
    }
}

