/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Mapper222
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int irqCounter;
    private int irqResetDelay;

    public Mapper222(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    @Override
    public void init() {
        this.setPrgBank(6, -2);
        this.setPrgBank(7, -1);
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        boolean a12;
        if (this.irqResetDelay > 0) {
            --this.irqResetDelay;
        }
        boolean bl = a12 = (address & 0x1000) != 0;
        if (a12 && this.irqResetDelay == 0 && this.irqCounter != 0 && ++this.irqCounter >= 240) {
            this.cpu.setMapperIrq(true);
            this.irqCounter = 0;
        }
        if (a12) {
            this.irqResetDelay = 8;
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xF003) {
            case 32768: {
                this.setPrgBank(4, value);
                break;
            }
            case 36864: {
                this.setNametableMirroring(value & 1);
                break;
            }
            case 40960: {
                this.setPrgBank(5, value);
                break;
            }
            case 45056: {
                this.setChrBank(0, value);
                break;
            }
            case 45058: {
                this.setChrBank(1, value);
                break;
            }
            case 49152: {
                this.setChrBank(2, value);
                break;
            }
            case 49154: {
                this.setChrBank(3, value);
                break;
            }
            case 53248: {
                this.setChrBank(4, value);
                break;
            }
            case 53250: {
                this.setChrBank(5, value);
                break;
            }
            case 57344: {
                this.setChrBank(6, value);
                break;
            }
            case 57346: {
                this.setChrBank(7, value);
                break;
            }
            case 61440: {
                this.irqCounter = value;
                this.cpu.setMapperIrq(false);
            }
        }
    }
}

