/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper212
extends Mapper {
    private static final long serialVersionUID = 0L;

    public Mapper212(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xE010) == 24576) {
            return 0x80 | super.readMemory(address);
        }
        return super.readMemory(address);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (BitUtil.getBitBool(address, 14)) {
            this.setPrgBanks(2, 2, address & 6);
        } else {
            this.setPrgBank(2, address & 7);
            this.setPrgBank(3, address & 7);
        }
        this.setChrBank(address & 7);
        this.setNametableMirroring(BitUtil.getBit(address, 3));
    }
}

