/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper083
extends Mapper {
    private static final long serialVersionUID = 0L;
    protected final int[] regs = new int[11];
    protected final int[] exRegs = new int[4];
    protected boolean is2kBank;
    protected boolean isNot2kBank;
    protected int mode;
    protected int bank;
    protected int resetBit;
    protected int irqCounter;
    protected boolean irqEnabled;

    public Mapper083(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    @Override
    public void init() {
        this.updateBanks();
    }

    @Override
    public void resetting() {
        this.resetBit ^= 1;
        this.updateBanks();
    }

    @Override
    public void update() {
        if (this.irqEnabled) {
            this.irqCounter = this.irqCounter - 1 & 0xFFFF;
            if (this.irqCounter == 0) {
                this.irqEnabled = false;
                this.irqCounter = 65535;
                this.cpu.setMapperIrq(true);
            }
        }
    }

    protected void updateBanks() {
        this.setNametableMirroring(this.mode & 3);
        if (this.is2kBank && !this.isNot2kBank) {
            this.setChrBanks(0, 2, this.regs[0] << 1);
            this.setChrBanks(2, 2, this.regs[1] << 1);
            this.setChrBanks(4, 2, this.regs[6] << 1);
            this.setChrBanks(6, 2, this.regs[7] << 1);
        } else {
            for (int i = 7; i >= 0; --i) {
                this.setChrBank(i, this.regs[i] | (this.bank & 0x30) << 4);
            }
        }
        if (BitUtil.getBitBool(this.mode, 6)) {
            this.setPrgBanks(4, 2, (this.bank & 0x3F) << 1);
            this.setPrgBanks(6, 2, (this.bank & 0x30 | 0xF) << 1);
        } else {
            this.setPrgBank(4, this.regs[8]);
            this.setPrgBank(5, this.regs[9]);
            this.setPrgBank(6, this.regs[10]);
            this.setPrgBank(7, -1);
        }
    }

    @Override
    public int readMemory(int address) {
        switch (address) {
            case 20480: {
                return this.resetBit;
            }
            case 20736: {
                return this.exRegs[0];
            }
            case 20737: {
                return this.exRegs[1];
            }
            case 20738: {
                return this.exRegs[2];
            }
            case 20739: {
                return this.exRegs[3];
            }
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        switch (address) {
            case 20736: {
                this.exRegs[0] = value;
                break;
            }
            case 20737: {
                this.exRegs[1] = value;
                break;
            }
            case 20738: {
                this.exRegs[2] = value;
                break;
            }
            case 20739: {
                this.exRegs[3] = value;
                break;
            }
            case 32768: {
                this.is2kBank = true;
                this.bank = value;
                this.mode |= 0x40;
                this.updateBanks();
                break;
            }
            case 33024: {
                this.mode = this.mode & 0x40 | value;
                this.updateBanks();
                break;
            }
            case 33280: {
                this.irqCounter = this.irqCounter & 0xFF00 | value;
                this.cpu.setMapperIrq(false);
                break;
            }
            case 33281: {
                this.irqEnabled = BitUtil.getBitBool(this.mode, 7);
                this.irqCounter = value << 8 | this.irqCounter & 0xFF;
                break;
            }
            case 45056: 
            case 45311: 
            case 45567: {
                this.bank = value;
                this.mode |= 0x40;
                this.updateBanks();
                break;
            }
            default: {
                if (address >= 33536 && address <= 33538) {
                    this.mode &= 0xBF;
                    this.regs[address - 33528] = value;
                    this.updateBanks();
                    break;
                }
                if (address < 33552 || address > 33559) break;
                this.regs[address - 33552] = value;
                if (address >= 33554 && address <= 33557) {
                    this.isNot2kBank = true;
                }
                this.updateBanks();
            }
        }
    }
}

