/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper062
extends Mapper {
    private static final long serialVersionUID = 0L;

    public Mapper062(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.writePrgBanks(address >> 8 & 0x3F | address & 0x40, BitUtil.getBitBool(address, 5));
        this.setChrBank(0, (address & 0x1F) << 2 | value & 3);
        this.setNametableMirroring(BitUtil.getBit(address, 7));
    }

    protected void writePrgBanks(int prgBank, boolean prgMode1) {
        if (prgMode1) {
            this.setPrgBank(2, prgBank);
            this.setPrgBank(3, prgBank);
        } else {
            this.setPrgBank(2, prgBank & 0xFE);
            this.setPrgBank(3, prgBank | 1);
        }
    }
}

