/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class BMC830425C4391T
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int innerBank;
    private int outerBank;

    public BMC830425C4391T(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.outerBank = 0;
        this.innerBank = 0;
        this.setNametableMirroring(0);
        this.updateState();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updateState() {
        int outer = this.outerBank & 0x7F;
        int size = BitUtil.getBitBool(this.outerBank, 7) ? 7 : 15;
        this.setPrgBank(2, outer | this.innerBank & size);
        this.setPrgBank(3, outer | size);
    }

    private void writeInnerBank(int value) {
        this.innerBank = value;
        this.updateState();
    }

    private void writeOuterBank(int address) {
        this.outerBank = (address & 0xFF) << 3;
        this.updateState();
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.writeInnerBank(value);
        if ((address & 0xFFE0) == 61664) {
            this.writeOuterBank(address);
        }
    }
}

