/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class BMC051
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int bank;
    private int mode;

    public BMC051(CartFile cartFile) {
        super(cartFile, 8, 1, 24576, 24576);
    }

    @Override
    public void init() {
        this.bank = 0;
        this.mode = 1;
        this.updateBanks();
    }

    private void updateBanks() {
        if (BitUtil.getBitBool(this.mode, 0)) {
            this.setPrgBank(3, 0x23 | this.bank << 2);
            this.setPrgBanks(4, 4, this.bank << 2);
        } else {
            this.setPrgBank(3, 0x2F | this.bank << 2);
            this.setPrgBanks(4, 2, this.bank << 2 | this.mode);
            this.setPrgBanks(6, 2, this.bank << 2 | 0xE);
        }
        this.setNametableMirroring(this.mode == 3 ? 1 : 0);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address < 32768) {
            this.mode = value >> 3 & 2 | value >> 1 & 1;
        } else if (address >= 49152 && address < 57344) {
            this.bank = value & 0xF;
            this.mode = value >> 3 & 2 | this.mode & 1;
        } else {
            this.bank = value & 0xF;
        }
        this.updateBanks();
    }
}

