/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.ntdec;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class BMC063
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean openBus;

    public BMC063(CartFile cartFile) {
        super(cartFile, 8, 1);
    }

    @Override
    public void resetting() {
        this.openBus = false;
    }

    @Override
    public int readMemory(int address) {
        if (this.openBus && (address & 0xC000) == 32768) {
            return 0;
        }
        return super.readMemory(address);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (this.openBus && address < 49152) {
            return;
        }
        boolean bl = this.openBus = (address & 0x300) == 768;
        if (!this.openBus) {
            this.setPrgBank(4, address >> 1 & 0x1FC | (BitUtil.getBitBool(address, 1) ? 0 : address >> 1 & 2));
            this.setPrgBank(5, address >> 1 & 0x1FC | (BitUtil.getBitBool(address, 1) ? 1 : address >> 1 & 2 | 1));
        }
        this.setPrgBank(6, address >> 1 & 0x1FC | (BitUtil.getBitBool(address, 1) ? 2 : address >> 1 & 2));
        this.setPrgBank(7, BitUtil.getBitBool(address, 11) ? address & 0x7C | ((address & 6) != 0 ? 3 : 1) : address >> 1 & 0x1FC | (BitUtil.getBitBool(address, 1) ? 3 : address >> 1 & 2 | 1));
        this.setNametableMirroring(address & 1);
    }
}

