/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.ntdec;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class AsderPC95
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int keyboardRow;

    public AsderPC95(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    private int readKeyboardButtonState() {
        int state = 0;
        this.writeOutputPort(5);
        for (int i = 0; i <= this.keyboardRow; ++i) {
            this.writeOutputPort(4);
            state = this.readInputPort(1) >> 1 & 0xF;
            this.writeOutputPort(6);
            state |= this.readInputPort(1) << 3 & 0xF0;
        }
        return state;
    }

    @Override
    public int readMemory(int address) {
        return address == 18694 ? this.readKeyboardButtonState() : super.readMemory(address);
    }

    private void writePrgRomBank(int address, int value) {
        int bank = 4 | address & 3;
        if (bank == 7) {
            value |= 1;
        }
        this.setPrgBank(bank, value);
    }

    private void writeChrRamBank(int address, int value) {
        this.setChrBank(address & 7, value);
    }

    private void writeKeyboardRow(int value) {
        this.keyboardRow = value;
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if (address == 18692) {
            this.writeKeyboardRow(value);
        } else {
            switch (address & 0xE000) {
                case 32768: {
                    this.writePrgRomBank(address, value);
                    break;
                }
                case 36864: {
                    this.writeChrRamBank(address, value);
                }
            }
        }
    }
}

