/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nitra;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class Mapper250
extends MMC3 {
    private static final long serialVersionUID = 0L;

    public Mapper250(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address < 32768) {
            this.memory[address] = value;
        } else {
            switch (address & 0xE400) {
                case 32768: {
                    this.writeBankSelect(address & 0xFF);
                    break;
                }
                case 33792: {
                    this.writeBankData(address & 0xFF);
                    break;
                }
                case 40960: {
                    this.writeMirroring(address & 0xFF);
                    break;
                }
                case 41984: {
                    this.writePrgRamProtect(address & 0xFF);
                    break;
                }
                case 49152: {
                    this.writeIrqLatch(address & 0xFF);
                    break;
                }
                case 50176: {
                    this.writeIrqReload();
                    break;
                }
                case 57344: {
                    this.writeIrqDisable();
                    break;
                }
                case 58368: {
                    this.writeIrqEnable();
                }
            }
        }
    }
}

