/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo.vs;

import nintaco.cartdb.Cart;
import nintaco.files.CartFile;
import nintaco.mappers.nintendo.vs.VsGame;
import nintaco.tv.TVSystem;

public class SplitCartFile
implements CartFile {
    private static final long serialVersionUID = 0L;
    private final CartFile cartFile;
    private final int[] prgROM;
    private final int[] chrROM;

    public SplitCartFile(CartFile cartFile, boolean main) {
        this.cartFile = cartFile;
        int[] _prgROM = cartFile.getPrgROM();
        this.prgROM = new int[_prgROM.length >> 1];
        System.arraycopy(_prgROM, main ? 0 : this.prgROM.length, this.prgROM, 0, this.prgROM.length);
        int[] _chrROM = cartFile.getChrROM();
        if (_chrROM.length == 32768) {
            this.chrROM = new int[_chrROM.length >> 1];
            System.arraycopy(_chrROM, main ? 0 : this.chrROM.length, this.chrROM, 0, this.chrROM.length);
        } else {
            this.chrROM = _chrROM;
        }
    }

    @Override
    public int[] getPrgROM() {
        return this.prgROM;
    }

    @Override
    public int[] getChrROM() {
        return this.chrROM;
    }

    @Override
    public int getPrgRomLength() {
        return this.prgROM.length;
    }

    @Override
    public int getChrRomLength() {
        return this.chrROM.length;
    }

    @Override
    public int getChrRamSize() {
        return this.cartFile.getChrRamSize();
    }

    @Override
    public int[] getFileContents() {
        return this.cartFile.getFileContents();
    }

    @Override
    public String getEntryFileName() {
        return this.cartFile.getEntryFileName();
    }

    @Override
    public String getArchiveFileName() {
        return this.cartFile.getArchiveFileName();
    }

    @Override
    public String getFileName() {
        return this.cartFile.getFileName();
    }

    @Override
    public boolean isChrRamPresent() {
        return this.cartFile.isChrRamPresent();
    }

    @Override
    public boolean isNonVolatilePrgRamPresent() {
        return this.cartFile.isNonVolatilePrgRamPresent();
    }

    @Override
    public TVSystem getTvSystem() {
        return this.cartFile.getTvSystem();
    }

    @Override
    public int getMirroring() {
        return this.cartFile.getMirroring();
    }

    @Override
    public int getFileCRC() {
        return this.cartFile.getFileCRC();
    }

    @Override
    public int getVsHardware() {
        return this.cartFile.getVsHardware();
    }

    @Override
    public Cart getCart() {
        return this.cartFile.getCart();
    }

    @Override
    public VsGame getVsGame() {
        return this.cartFile.getVsGame();
    }

    @Override
    public boolean isVsSystem() {
        return this.cartFile.isVsSystem();
    }

    @Override
    public boolean isVsUniSystem() {
        return this.cartFile.isVsUniSystem();
    }

    @Override
    public boolean isVsDualSystem() {
        return this.cartFile.isVsDualSystem();
    }

    @Override
    public int getMapperNumber() {
        return this.cartFile.getMapperNumber();
    }

    @Override
    public int getSubmapperNumber() {
        return this.cartFile.getSubmapperNumber();
    }

    @Override
    public boolean isTrainerPresent() {
        return this.cartFile.isTrainerPresent();
    }

    @Override
    public int getTrainerSize() {
        return this.cartFile.getTrainerSize();
    }

    @Override
    public int[] getTrainer() {
        return this.cartFile.getTrainer();
    }

    @Override
    public int getFileType() {
        return this.cartFile.getFileType();
    }

    @Override
    public int getConsole() {
        return this.cartFile.getConsole();
    }

    @Override
    public int getExtendedConsole() {
        return this.cartFile.getExtendedConsole();
    }
}

