/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo.vs;

import nintaco.Machine;
import nintaco.files.CartFile;
import nintaco.input.DeviceMapper;
import nintaco.input.InputDevices;
import nintaco.input.gamepad.GamepadMapper;
import nintaco.mappers.Mapper;
import nintaco.mappers.nintendo.vs.MainCPU;
import nintaco.mappers.nintendo.vs.SplitCartFile;
import nintaco.mappers.nintendo.vs.SubVsDualSystem;
import nintaco.util.BitUtil;

public class MainVsDualSystem
extends Mapper {
    private static final long serialVersionUID = 0L;
    private SubVsDualSystem subVsDualSystem;

    public MainVsDualSystem(CartFile cartFile) {
        super(new SplitCartFile(cartFile, true), 8, 1);
        this.setNametableMirroring(4);
        this.setPrgBank(4, 0);
        this.setPrgBank(5, 1);
        this.setPrgBank(6, 2);
        this.setPrgBank(7, 3);
        this.subVsDualSystem = new SubVsDualSystem(cartFile);
        this.subVsDualSystem.setMainVsDualSystem(this);
    }

    @Override
    public boolean isVsDualSystem() {
        return true;
    }

    public SubVsDualSystem getSubVsDualSystem() {
        return this.subVsDualSystem;
    }

    public void setSubVsDualSystem(SubVsDualSystem subVsDualSystem) {
        this.subVsDualSystem = subVsDualSystem;
    }

    @Override
    public void restore(CartFile cartFile) {
        if (cartFile instanceof SplitCartFile) {
            super.restore(cartFile);
        } else if (cartFile != null) {
            super.restore(new SplitCartFile(cartFile, true));
            this.subVsDualSystem.restore(new SplitCartFile(cartFile, false));
        }
    }

    @Override
    public int readCpuMemory(int address) {
        if ((address & 0xE000) == 24576) {
            return this.memory[0x6000 | address & 0x7FF];
        }
        return super.readCpuMemory(address);
    }

    @Override
    public void writeCpuMemory(int address, int value) {
        if ((address & 0xE000) == 24576) {
            this.memory[0x6000 | address & 0x7FF] = value;
        } else {
            if (address == 16406) {
                this.writeBankSelect(value);
            }
            super.writeCpuMemory(address, value);
        }
    }

    public void setMapperIrq(boolean value) {
        this.cpu.setMapperIrq(value);
    }

    private void writeBankSelect(int value) {
        int bank = BitUtil.getBit(value, 2);
        this.setChrBank(bank);
        if (this.prgRomLength > 32768) {
            this.setPrgBank(4, bank << 2);
        }
        if (BitUtil.getBitBool(value, 1)) {
            this.subVsDualSystem.setMapperIrq(false);
        } else {
            this.subVsDualSystem.setMapperIrq(true);
        }
    }

    @Override
    public void setMachine(Machine machine) {
        super.setMachine(machine);
        MainCPU mainCPU = (MainCPU)machine.getCPU();
        this.subVsDualSystem.setCPU(mainCPU.getSubCPU());
        this.subVsDualSystem.setPPU(mainCPU.getSubPPU());
        this.subVsDualSystem.setAPU(mainCPU.getSubAPU());
    }

    @Override
    public void setDipSwitchesValue(int dipSwitchesValue) {
        super.setDipSwitchesValue(dipSwitchesValue & 0xFF);
        this.subVsDualSystem.setDipSwitchesValue(dipSwitchesValue >> 8 & 0xFF);
    }

    @Override
    public void init() {
        super.init();
        this.subVsDualSystem.init();
    }

    @Override
    public void setDeviceMappers(DeviceMapper[] deviceMappers) {
        super.setDeviceMappers(deviceMappers);
        this.subVsDualSystem.setDeviceMappers(deviceMappers);
    }

    @Override
    public void updateButtons(int buttons) {
        super.updateButtons(buttons);
        this.subVsDualSystem.updateButtons(buttons);
    }

    @Override
    public void insertCoin(int vsSystem, int coinSlot) {
        if (vsSystem == 0) {
            super.insertCoin(vsSystem, coinSlot);
        } else {
            this.subVsDualSystem.insertCoin(vsSystem, coinSlot);
        }
    }

    @Override
    public void pressServiceButton(int vsSystem) {
        if (vsSystem == 0) {
            super.pressServiceButton(vsSystem);
        } else {
            this.subVsDualSystem.pressServiceButton(vsSystem);
        }
    }

    @Override
    public void writeOutputPort(int value) {
        DeviceMapper[] mappers = this.deviceMappers;
        for (int i = mappers.length - 1; i >= 0; --i) {
            DeviceMapper mapper = mappers[i];
            if (!InputDevices.isGamepad(mapper.getInputDevice()) || ((GamepadMapper)mapper).getPortIndex() > 1) continue;
            mappers[i].writePort(value);
        }
    }

    @Override
    public int readInputPort(int portIndex) {
        DeviceMapper[] mappers = this.deviceMappers;
        int value = portIndex == 0 ? this.coinMask | (this.dipSwitchesValue & 3) << 3 | this.serviceButtonMask : this.dipSwitchesValue & 0xFC;
        for (int i = mappers.length - 1; i >= 0; --i) {
            value |= mappers[i].readPort(portIndex);
        }
        return value;
    }

    @Override
    public int peekInputPort(int portIndex) {
        DeviceMapper[] mappers = this.deviceMappers;
        int value = portIndex == 0 ? this.coinMask | (this.dipSwitchesValue & 3) << 3 | this.serviceButtonMask : this.dipSwitchesValue & 0xFC;
        for (int i = mappers.length - 1; i >= 0; --i) {
            value |= mappers[i].peekPort(portIndex);
        }
        return value;
    }

    @Override
    public void setVramMask(int vramMask) {
        super.setVramMask(vramMask);
        this.subVsDualSystem.setVramMask(vramMask);
    }
}

