/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo.fds;

import java.util.Arrays;
import nintaco.mappers.Audio;
import nintaco.tv.TVSystem;
import nintaco.util.BitUtil;

public final class FdsAudio
extends Audio {
    private static final long serialVersionUID = 0L;
    private static final double CUTOFF_FREQUENCY = 2000.0;
    private static final float SMOOTH;
    private static final int FDS_AUDIO_MAX = 20251;
    private static final int APU_AUDIO_MAX = 45284;
    private static final float INV_SMOOTH;
    private static final int[] MOD_ADJUSTMENTS;
    private static final float MAX_OUTPUT = 2016.0f;
    private static final float[] MASTER_VOLUMES;
    private static float volume;
    private final int[] modTable = new int[64];
    private final int[] volumeTable = new int[64];
    private float masterVolume;
    private float audioSample;
    private int volumeOutput;
    private int volumeSpeed;
    private int volumeGain;
    private int modSpeed;
    private int modGain;
    private int volumeFrequency;
    private int modCounter;
    private int modFrequency;
    private int envelopeSpeed;
    private int volumeOutputPosition;
    private int volumeTimer;
    private int modOutputPosition;
    private int modTimer;
    private int modAccumulator;
    private int volumeAccumulator;
    private boolean volumeAndSweepEnabled;
    private boolean volumeEnabled;
    private boolean volumeIncrease;
    private boolean volumeGainEnabled;
    private boolean modIncrease;
    private boolean modGainEnabled;
    private boolean volumeTableWriteEnabled;
    private boolean modEnabled;
    private boolean soundIOEnabled;

    public static void setVolume(int volume) {
        FdsAudio.volume = (float)volume / 100.0f;
    }

    @Override
    public void reset() {
        this.masterVolume = 0.0f;
        this.audioSample = 0.0f;
        this.volumeOutput = 0;
        this.volumeSpeed = 0;
        this.volumeGain = 0;
        this.modSpeed = 0;
        this.modGain = 0;
        this.volumeFrequency = 0;
        this.modCounter = 0;
        this.modFrequency = 0;
        this.envelopeSpeed = 0;
        this.volumeOutputPosition = 0;
        this.volumeTimer = 0;
        this.modOutputPosition = 0;
        this.modTimer = 0;
        this.modAccumulator = 0;
        this.volumeAccumulator = 0;
        this.volumeAndSweepEnabled = false;
        this.volumeEnabled = false;
        this.volumeIncrease = false;
        this.volumeGainEnabled = false;
        this.modIncrease = false;
        this.modGainEnabled = false;
        this.volumeTableWriteEnabled = false;
        this.modEnabled = false;
        this.soundIOEnabled = false;
        Arrays.fill(this.modTable, 0);
        Arrays.fill(this.volumeTable, 0);
    }

    @Override
    public boolean writeRegister(int address, int value) {
        if ((address & 0xFFC0) == 16448) {
            this.writeVolumeTable(address, value);
            return true;
        }
        switch (address) {
            case 16419: {
                this.writeMasterIOEnable(value);
                return false;
            }
            case 16512: {
                this.writeVolumeEnvelope(value);
                return true;
            }
            case 16514: {
                this.writeVolumeFrequencyLow(value);
                return true;
            }
            case 16515: {
                this.writeVolumeFrequencyHigh(value);
                return true;
            }
            case 16516: {
                this.writeModEnvelope(value);
                return true;
            }
            case 16517: {
                this.writeModCounter(value);
                return true;
            }
            case 16518: {
                this.writeModFrequencyLow(value);
                return true;
            }
            case 16519: {
                this.writeModFrequencyHigh(value);
                return true;
            }
            case 16520: {
                this.writeModTable(value);
                return true;
            }
            case 16521: {
                this.writeMasterVolume(value);
                return true;
            }
            case 16522: {
                this.writeEnvelopeSpeed(value);
                return true;
            }
        }
        return false;
    }

    @Override
    public int readRegister(int address) {
        if (address == 16528) {
            return this.readVolumeGain();
        }
        if (address == 16530) {
            return this.readModGain();
        }
        if ((address & 0xFFC0) == 16448) {
            return this.readVolumeTable(address);
        }
        return -1;
    }

    @Override
    public void update() {
        if (this.volumeAndSweepEnabled && this.volumeEnabled && this.envelopeSpeed != 0) {
            if (this.volumeGainEnabled && --this.volumeTimer < 0) {
                this.tickVolumeUnit();
            }
            if (this.modGainEnabled && --this.modTimer < 0) {
                this.tickModUnit();
            }
        }
        if (this.modEnabled) {
            this.modAccumulator += this.modFrequency;
            while (this.modAccumulator >= 65536) {
                this.modAccumulator -= 65536;
                int modValue = this.modTable[this.modOutputPosition];
                this.modOutputPosition = this.modOutputPosition + 1 & 0x3F;
                if (modValue == 4) {
                    this.modCounter = 0;
                    continue;
                }
                this.modCounter = this.modCounter + MOD_ADJUSTMENTS[modValue] << 25 >> 25;
            }
        }
        if (this.volumeEnabled) {
            int modulatedPitch;
            if (this.modGain != 0) {
                modulatedPitch = this.modCounter * this.modGain;
                int remainder = modulatedPitch & 0xF;
                if (remainder > 0 && ((modulatedPitch >>= 4) & 0x80) == 0) {
                    modulatedPitch = this.modCounter < 0 ? --modulatedPitch : (modulatedPitch += 2);
                }
                modulatedPitch = ((modulatedPitch + 64 & 0xFF) - 64) * this.volumeFrequency;
                remainder = modulatedPitch & 0x3F;
                modulatedPitch >>= 6;
                if (remainder >= 32) {
                    ++modulatedPitch;
                }
            } else {
                modulatedPitch = 0;
            }
            this.volumeAccumulator += this.volumeFrequency + modulatedPitch;
            while (this.volumeAccumulator >= 65536) {
                this.volumeAccumulator -= 65536;
                this.volumeOutputPosition = this.volumeOutputPosition + 1 & 0x3F;
            }
        }
        if (!this.volumeTableWriteEnabled) {
            this.volumeOutput = this.volumeGain;
            if (this.volumeOutput > 32) {
                this.volumeOutput = 32;
            }
            this.volumeOutput *= this.volumeTable[this.volumeOutputPosition];
        }
        this.audioSample = (float)this.volumeOutput * this.masterVolume + INV_SMOOTH * this.audioSample;
    }

    private void writeMasterIOEnable(int value) {
        this.soundIOEnabled = BitUtil.getBitBool(value, 1);
    }

    private void writeVolumeTable(int address, int value) {
        if (this.volumeTableWriteEnabled) {
            this.volumeTable[address & 0x3F] = value & 0x3F;
        }
    }

    private int readVolumeTable(int address) {
        return this.volumeTable[address & 0x3F];
    }

    private void writeVolumeEnvelope(int value) {
        this.volumeSpeed = value & 0x3F;
        this.volumeIncrease = BitUtil.getBitBool(value, 6);
        this.volumeGainEnabled = !BitUtil.getBitBool(value, 7);
        this.resetVolumeTimer();
        if (!this.volumeGainEnabled) {
            this.volumeGain = this.volumeSpeed;
        }
    }

    private void writeVolumeFrequencyLow(int value) {
        this.volumeFrequency = this.volumeFrequency & 0xF00 | value;
    }

    private void writeVolumeFrequencyHigh(int value) {
        this.volumeFrequency = this.volumeFrequency & 0xFF | (value & 0xF) << 8;
        this.volumeAndSweepEnabled = !BitUtil.getBitBool(value, 6);
        boolean bl = this.volumeEnabled = !BitUtil.getBitBool(value, 7);
        if (!this.volumeEnabled) {
            this.volumeAccumulator = 0;
        }
        if (!this.volumeAndSweepEnabled) {
            this.resetVolumeTimer();
            this.resetModTimer();
        }
    }

    private void writeModEnvelope(int value) {
        this.modSpeed = value & 0x3F;
        this.modIncrease = BitUtil.getBitBool(value, 6);
        this.modGainEnabled = !BitUtil.getBitBool(value, 7);
        this.resetModTimer();
        if (!this.modGainEnabled) {
            this.modGain = this.modSpeed;
        }
    }

    private void writeModCounter(int value) {
        this.modAccumulator = 0;
        this.modCounter = (value & 0x7F) << 25 >> 25;
    }

    private void writeModFrequencyLow(int value) {
        this.modFrequency = this.modFrequency & 0xF00 | value;
    }

    private void writeModFrequencyHigh(int value) {
        this.modFrequency = this.modFrequency & 0xFF | (value & 0xF) << 8;
        boolean bl = this.modEnabled = !BitUtil.getBitBool(value, 7);
        if (!this.modEnabled) {
            this.modAccumulator = 0;
        }
    }

    private void writeModTable(int value) {
        if (!this.modEnabled) {
            this.modTable[this.modOutputPosition + 1 & 0x3F] = this.modTable[this.modOutputPosition] = value & 7;
            this.modOutputPosition = this.modOutputPosition + 2 & 0x3F;
        }
    }

    private void writeMasterVolume(int value) {
        this.masterVolume = MASTER_VOLUMES[value & 3];
        this.volumeTableWriteEnabled = BitUtil.getBitBool(value, 7);
    }

    private void writeEnvelopeSpeed(int value) {
        this.envelopeSpeed = value;
        this.resetVolumeTimer();
        this.resetModTimer();
    }

    private int readVolumeGain() {
        return 0x40 | this.volumeGain;
    }

    private int readModGain() {
        return 0x40 | this.modGain;
    }

    private void resetVolumeTimer() {
        this.volumeTimer = (this.volumeSpeed + 1 << 3) * this.envelopeSpeed;
    }

    private void resetModTimer() {
        this.modTimer = (this.modSpeed + 1 << 3) * this.envelopeSpeed;
    }

    private void tickVolumeUnit() {
        if (this.volumeIncrease) {
            if (this.volumeGain < 32) {
                ++this.volumeGain;
            }
        } else if (this.volumeGain > 0) {
            --this.volumeGain;
        }
        this.resetVolumeTimer();
    }

    private void tickModUnit() {
        if (this.modIncrease) {
            if (this.modGain < 32) {
                ++this.modGain;
            }
        } else if (this.modGain > 0) {
            --this.modGain;
        }
        this.resetModTimer();
    }

    @Override
    public float getAudioSample() {
        return volume * this.audioSample;
    }

    @Override
    public int getAudioMixerScale() {
        return 45284;
    }

    static {
        double SAMPLE_PERIOD = TVSystem.NTSC.getSecondsPerCycle();
        double X = Math.PI * 2 * SAMPLE_PERIOD * 2000.0;
        SMOOTH = (float)(X / (X + 1.0));
        INV_SMOOTH = 1.0f - SMOOTH;
        MOD_ADJUSTMENTS = new int[]{0, 1, 2, 4, 0, -4, -2, -1};
        MASTER_VOLUMES = new float[]{SMOOTH * 20251.0f / 2016.0f, 2.0f * SMOOTH * 20251.0f / 6048.0f, SMOOTH * 20251.0f / 4032.0f, 2.0f * SMOOTH * 20251.0f / 10080.0f};
        FdsAudio.setVolume(100);
    }
}

