/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.namco;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class DxROM
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int[][] VS_SECURITY_DATA = new int[][]{{255, 191, 183, 151, 151, 23, 87, 79, 111, 107, 235, 169, 177, 144, 148, 20, 86, 78, 111, 107, 235, 169, 177, 144, 212, 92, 62, 38, 135, 131, 19, 0}, {0, 0, 0, 0, 180, 0, 0, 0, 0, 111, 0, 0, 0, 0, 148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    private int vsSecurityTable = -1;
    private int vsSecurityIndex;
    private boolean vsSecurityEnabled;
    private boolean vsSuperXevious;
    private boolean xeviousSelect;
    protected int register;

    public DxROM(CartFile cartFile) {
        super(cartFile, 8, 8);
        switch (cartFile.getVsHardware()) {
            case 2: {
                this.vsSecurityTable = 0;
                break;
            }
            case 1: {
                this.vsSecurityTable = 1;
                break;
            }
            case 3: {
                this.vsSuperXevious = true;
            }
        }
        this.vsSecurityEnabled = this.vsSecurityTable >= 0;
        this.setPrgBank(4, 0);
        this.setPrgBank(5, 1);
        this.setPrgBank(6, -2);
        this.setPrgBank(7, -1);
    }

    @Override
    public int readMemory(int address) {
        if (this.vsSecurityEnabled && (address & 0xFFFE) == 24064) {
            if (BitUtil.getBitBool(address, 0)) {
                return VS_SECURITY_DATA[this.vsSecurityTable][this.vsSecurityIndex++ & 0x1F];
            }
            this.vsSecurityIndex = 0;
            return 94;
        }
        if (this.vsSuperXevious && (address & 0xFC00) == 21504) {
            switch (address) {
                case 21759: {
                    return 5;
                }
                case 22136: {
                    return this.xeviousSelect ? 0 : 1;
                }
                case 22415: {
                    return this.xeviousSelect ? 209 : 137;
                }
                case 21863: {
                    this.xeviousSelect ^= true;
                    return this.xeviousSelect ? 55 : 62;
                }
            }
            return 0;
        }
        return super.readMemory(address);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (BitUtil.getBitBool(address, 0)) {
            this.writeRegisterValue(value);
        } else {
            this.writeRegisterIndex(value);
        }
    }

    protected void writeRegisterIndex(int value) {
        this.register = value & 7;
    }

    protected void writeRegisterValue(int value) {
        switch (this.register) {
            case 0: {
                this.writeChrBank2K(0, value);
                break;
            }
            case 1: {
                this.writeChrBank2K(2, value);
                break;
            }
            case 2: {
                this.writeChrBank(4, value);
                break;
            }
            case 3: {
                this.writeChrBank(5, value);
                break;
            }
            case 4: {
                this.writeChrBank(6, value);
                break;
            }
            case 5: {
                this.writeChrBank(7, value);
                break;
            }
            case 6: {
                this.writePrgBank(4, value);
                break;
            }
            case 7: {
                this.writePrgBank(5, value);
            }
        }
    }

    protected void writePrgBank(int bank, int value) {
        this.setPrgBank(bank, value & 0xF);
    }

    protected void writeChrBank(int bank, int value) {
        this.setChrBank(bank, value & 0x3F);
    }

    protected void writeChrBank2K(int bank, int value) {
        this.setChrBank(bank, value &= 0x3E);
        this.setChrBank(bank + 1, value | 1);
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            return this.readChr(address);
        }
        return this.vram[address];
    }

    protected int readChr(int address) {
        return this.chrROM[(this.chrBanks[address >> 10] | address & 0x3FF) & this.chrRomSizeMask];
    }
}

