/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.konami.vrc7;

import nintaco.mappers.konami.vrc7.OPLL;
import nintaco.mappers.konami.vrc7.OPLL_PATCH;
import nintaco.mappers.konami.vrc7.OPLL_SLOT;

public final class Emu2413 {
    private static final short[] default_inst = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 3, 33, 5, 6, 184, 130, 66, 39, 19, 65, 19, 13, 216, 214, 35, 18, 49, 17, 8, 8, 250, 154, 34, 2, 49, 97, 24, 7, 120, 100, 48, 39, 34, 33, 30, 6, 240, 118, 8, 40, 2, 1, 6, 0, 240, 242, 3, 245, 33, 97, 29, 7, 130, 129, 22, 7, 35, 33, 26, 23, 207, 114, 37, 23, 21, 17, 37, 0, 79, 113, 0, 17, 133, 1, 18, 15, 153, 162, 64, 2, 7, 193, 105, 7, 243, 245, 167, 18, 113, 35, 13, 6, 102, 117, 35, 22, 1, 2, 211, 5, 163, 146, 247, 82, 97, 99, 12, 0, 148, 175, 52, 6, 33, 98, 13, 0, 177, 160, 84, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int PG_BITS = 9;
    private static final int PG_WIDTH = 512;
    private static final int DP_BITS = 18;
    private static final int DP_WIDTH = 262144;
    private static final int DP_BASE_BITS = 9;
    private static final int DB_BITS = 8;
    private static final double DB_STEP = 0.1875;
    private static final int DB_MUTE = 256;
    private static final double EG_STEP = 0.375;
    private static final int EG_BITS = 7;
    private static final double TL_STEP = 0.75;
    private static final int TL_BITS = 6;
    private static final double SL_STEP = 3.0;
    private static final int DB2LIN_AMP_BITS = 8;
    private static final int SLOT_AMP_BITS = 8;
    private static final int EG_DP_BITS = 22;
    private static final int EG_DP_WIDTH = 0x400000;
    private static final int PM_PG_BITS = 8;
    private static final int PM_PG_WIDTH = 256;
    private static final int PM_DP_BITS = 16;
    private static final int PM_DP_WIDTH = 65536;
    private static final int AM_PG_BITS = 8;
    private static final int AM_PG_WIDTH = 256;
    private static final int AM_DP_BITS = 16;
    private static final int AM_DP_WIDTH = 65536;
    private static final int PM_AMP_BITS = 8;
    private static final int PM_AMP = 256;
    private static final double PM_SPEED = 6.4;
    private static final double PM_DEPTH = 13.75;
    private static final double AM_SPEED = 3.6413;
    private static final double AM_DEPTH = 4.875;
    private static final int clk = 3579545;
    private static final int rate = 49716;
    private static final int[] fullsintable = new int[512];
    private static final int[] halfsintable = new int[512];
    private static final int[][] waveform = new int[][]{fullsintable, halfsintable};
    private static final int[] pmtable = new int[256];
    private static final int[] amtable = new int[256];
    private static final int pm_dphase = 8;
    private static final int am_dphase = 4;
    private static final int[] DB2LIN_TABLE = new int[1024];
    private static final int[] AR_ADJUST_TABLE = new int[128];
    private static final OPLL_PATCH[] default_patch = new OPLL_PATCH[38];
    private static final int[][] dphaseARTable = new int[16][16];
    private static final int[][] dphaseDRTable = new int[16][16];
    private static final int[][][][] tllTable = new int[16][8][64][4];
    private static final int[][][] rksTable = new int[2][8][2];
    private static final int[][][] dphaseTable = new int[512][8][16];
    private static final int[] mltable = new int[]{1, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 20, 24, 24, 30, 30};
    private static final double[] kltable = new double[]{Emu2413.dB2(0.0), Emu2413.dB2(9.0), Emu2413.dB2(12.0), Emu2413.dB2(13.875), Emu2413.dB2(15.0), Emu2413.dB2(16.125), Emu2413.dB2(16.875), Emu2413.dB2(17.625), Emu2413.dB2(18.0), Emu2413.dB2(18.75), Emu2413.dB2(19.125), Emu2413.dB2(19.5), Emu2413.dB2(19.875), Emu2413.dB2(20.25), Emu2413.dB2(20.625), Emu2413.dB2(21.0)};
    private static final int SLOT_BD1 = 12;
    private static final int SLOT_BD2 = 13;
    private static final int SLOT_HH = 14;
    private static final int SLOT_SD = 15;
    private static final int SLOT_TOM = 16;
    private static final int SLOT_CYM = 17;
    private static final int[] SL = new int[]{Emu2413.S2E(0.0), Emu2413.S2E(3.0), Emu2413.S2E(6.0), Emu2413.S2E(9.0), Emu2413.S2E(12.0), Emu2413.S2E(15.0), Emu2413.S2E(18.0), Emu2413.S2E(21.0), Emu2413.S2E(24.0), Emu2413.S2E(27.0), Emu2413.S2E(30.0), Emu2413.S2E(33.0), Emu2413.S2E(36.0), Emu2413.S2E(39.0), Emu2413.S2E(42.0), Emu2413.S2E(48.0)};

    private static int EG2DB(int d) {
        return d * 2;
    }

    private static int TL2EG(int d) {
        return d * 2;
    }

    private static int SL2EG(int d) {
        return d * 8;
    }

    private static int DB_POS(double x) {
        return (int)(x / 0.1875);
    }

    private static int DB_NEG(double x) {
        return (int)(512.0 + x / 0.1875);
    }

    private static int HIGHBITS(int c, int b) {
        return c >> b;
    }

    private static int EXPAND_BITS(int x, int s, int d) {
        return x << d - s;
    }

    private static OPLL_SLOT MOD(OPLL o, int x) {
        return o.slot[x << 1];
    }

    private static OPLL_SLOT CAR(OPLL o, int x) {
        return o.slot[x << 1 | 1];
    }

    private static boolean BIT(int s, int b) {
        return (s >> b & 1) != 0;
    }

    private static void makeAdjustTable() {
        Emu2413.AR_ADJUST_TABLE[0] = 127;
        for (int i = 1; i < 128; ++i) {
            Emu2413.AR_ADJUST_TABLE[i] = (int)(127.0 - 127.0 * Math.log(i) / Math.log(127.0));
        }
    }

    private static void makeDB2LinTable() {
        for (int i = 0; i < 512; ++i) {
            Emu2413.DB2LIN_TABLE[i] = (int)(255.0 * Math.pow(10.0, (double)(-i) * 0.1875 / 20.0));
            if (i >= 256) {
                Emu2413.DB2LIN_TABLE[i] = 0;
            }
            Emu2413.DB2LIN_TABLE[i + 256 + 256] = -DB2LIN_TABLE[i];
        }
    }

    private static int lin2db(double d) {
        if (d == 0.0) {
            return 255;
        }
        return Math.min(-((int)(20.0 * Math.log10(d) / 0.1875)), 255);
    }

    private static void makeSinTable() {
        int i;
        for (i = 0; i < 128; ++i) {
            Emu2413.fullsintable[i] = Emu2413.lin2db(Math.sin(Math.PI * 2 * (double)i / 512.0));
        }
        for (i = 0; i < 128; ++i) {
            Emu2413.fullsintable[255 - i] = fullsintable[i];
        }
        for (i = 0; i < 256; ++i) {
            Emu2413.fullsintable[256 + i] = 512 + fullsintable[i];
        }
        System.arraycopy(fullsintable, 0, halfsintable, 0, 256);
        for (i = 256; i < 512; ++i) {
            Emu2413.halfsintable[i] = fullsintable[0];
        }
    }

    private static double saw(double phase) {
        if (phase <= 1.5707963267948966) {
            return phase * 2.0 / Math.PI;
        }
        if (phase <= 4.71238898038469) {
            return 2.0 - phase * 2.0 / Math.PI;
        }
        return -4.0 + phase * 2.0 / Math.PI;
    }

    private static void makePmTable() {
        for (int i = 0; i < 256; ++i) {
            Emu2413.pmtable[i] = (int)(256.0 * Math.pow(2.0, 13.75 * Emu2413.saw(Math.PI * 2 * (double)i / 256.0) / 1200.0));
        }
    }

    private static void makeAmTable() {
        for (int i = 0; i < 256; ++i) {
            Emu2413.amtable[i] = (int)(13.0 * (1.0 + Emu2413.saw(Math.PI * 2 * (double)i / 256.0)));
        }
    }

    private static void makeDphaseTable() {
        for (int fnum = 0; fnum < 512; ++fnum) {
            for (int block = 0; block < 8; ++block) {
                for (int ML = 0; ML < 16; ++ML) {
                    Emu2413.dphaseTable[fnum][block][ML] = fnum * mltable[ML] << block >> 2;
                }
            }
        }
    }

    private static double dB2(double x) {
        return x * 2.0;
    }

    private static void makeTllTable() {
        for (int fnum = 0; fnum < 16; ++fnum) {
            for (int block = 0; block < 8; ++block) {
                for (int TL = 0; TL < 64; ++TL) {
                    for (int KL = 0; KL < 4; ++KL) {
                        int tmp;
                        Emu2413.tllTable[fnum][block][TL][KL] = KL == 0 ? Emu2413.TL2EG(TL) : ((tmp = (int)(kltable[fnum] - Emu2413.dB2(3.0) * (double)(7 - block))) <= 0 ? Emu2413.TL2EG(TL) : (int)((double)(tmp >> 3 - KL) / 0.375) + Emu2413.TL2EG(TL));
                    }
                }
            }
        }
    }

    private static void makeDphaseARTable() {
        for (int AR = 0; AR < 16; ++AR) {
            block5: for (int Rks = 0; Rks < 16; ++Rks) {
                int RM = AR + (Rks >> 2);
                int RL = Rks & 3;
                if (RM > 15) {
                    RM = 15;
                }
                switch (AR) {
                    case 0: {
                        Emu2413.dphaseARTable[AR][Rks] = 0;
                        continue block5;
                    }
                    case 15: {
                        Emu2413.dphaseARTable[AR][Rks] = 0;
                        continue block5;
                    }
                    default: {
                        Emu2413.dphaseARTable[AR][Rks] = 3 * (RL + 4) << RM + 1;
                    }
                }
            }
        }
    }

    private static void makeDphaseDRTable() {
        for (int DR = 0; DR < 16; ++DR) {
            block4: for (int Rks = 0; Rks < 16; ++Rks) {
                int RM = DR + (Rks >> 2);
                int RL = Rks & 3;
                if (RM > 15) {
                    RM = 15;
                }
                switch (DR) {
                    case 0: {
                        Emu2413.dphaseDRTable[DR][Rks] = 0;
                        continue block4;
                    }
                    default: {
                        Emu2413.dphaseDRTable[DR][Rks] = RL + 4 << RM - 1;
                    }
                }
            }
        }
    }

    private static void makeRksTable() {
        for (int fnum8 = 0; fnum8 < 2; ++fnum8) {
            for (int block = 0; block < 8; ++block) {
                for (int KR = 0; KR < 2; ++KR) {
                    Emu2413.rksTable[fnum8][block][KR] = KR != 0 ? (block << 1) + fnum8 : block >> 1;
                }
            }
        }
    }

    private static void OPLL_dump2patch(short[] dump, OPLL_PATCH[] patch) {
        patch[0].AM = dump[0] >> 7 & 1;
        patch[1].AM = dump[1] >> 7 & 1;
        patch[0].PM = dump[0] >> 6 & 1;
        patch[1].PM = dump[1] >> 6 & 1;
        patch[0].EG = dump[0] >> 5 & 1;
        patch[1].EG = dump[1] >> 5 & 1;
        patch[0].KR = dump[0] >> 4 & 1;
        patch[1].KR = dump[1] >> 4 & 1;
        patch[0].ML = dump[0] & 0xF;
        patch[1].ML = dump[1] & 0xF;
        patch[0].KL = dump[2] >> 6 & 3;
        patch[1].KL = dump[3] >> 6 & 3;
        patch[0].TL = dump[2] & 0x3F;
        patch[0].FB = dump[3] & 7;
        patch[0].WF = dump[3] >> 3 & 1;
        patch[1].WF = dump[3] >> 4 & 1;
        patch[0].AR = dump[4] >> 4 & 0xF;
        patch[1].AR = dump[5] >> 4 & 0xF;
        patch[0].DR = dump[4] & 0xF;
        patch[1].DR = dump[5] & 0xF;
        patch[0].SL = dump[6] >> 4 & 0xF;
        patch[1].SL = dump[7] >> 4 & 0xF;
        patch[0].RR = dump[6] & 0xF;
        patch[1].RR = dump[7] & 0xF;
    }

    private static void OPLL_getDefaultPatch(int num, OPLL_PATCH[] patch) {
        short[] r = new short[8];
        System.arraycopy(default_inst, num * 8, r, 0, r.length);
        Emu2413.OPLL_dump2patch(r, patch);
    }

    private static void makeDefaultPatch() {
        for (int i = 0; i < 19; ++i) {
            OPLL_PATCH[] oPLL_PATCHArray = new OPLL_PATCH[2];
            OPLL_PATCH oPLL_PATCH = new OPLL_PATCH();
            Emu2413.default_patch[i * 2] = oPLL_PATCH;
            oPLL_PATCHArray[0] = oPLL_PATCH;
            OPLL_PATCH oPLL_PATCH2 = new OPLL_PATCH();
            Emu2413.default_patch[i * 2 + 1] = oPLL_PATCH2;
            oPLL_PATCHArray[1] = oPLL_PATCH2;
            Emu2413.OPLL_getDefaultPatch(i, oPLL_PATCHArray);
        }
    }

    private static int calc_eg_dphase(OPLL_SLOT slot) {
        switch (slot.eg_mode) {
            case 1: {
                return dphaseARTable[slot.patch.AR][slot.rks];
            }
            case 2: {
                return dphaseDRTable[slot.patch.DR][slot.rks];
            }
            case 3: {
                return 0;
            }
            case 4: {
                return dphaseDRTable[slot.patch.RR][slot.rks];
            }
            case 5: {
                if (slot.sustine) {
                    return dphaseDRTable[5][slot.rks];
                }
                if (slot.patch.EG != 0) {
                    return dphaseDRTable[slot.patch.RR][slot.rks];
                }
                return dphaseDRTable[7][slot.rks];
            }
            case 6: {
                return dphaseDRTable[15][0];
            }
            case 7: {
                return 0;
            }
        }
        return 0;
    }

    private static void UPDATE_PG(OPLL_SLOT S) {
        S.dphase = dphaseTable[S.fnum][S.block][S.patch.ML];
    }

    private static void UPDATE_TLL(OPLL_SLOT S) {
        S.tll = S.type ? tllTable[S.fnum >> 5][S.block][S.volume][S.patch.KL] : tllTable[S.fnum >> 5][S.block][S.patch.TL][S.patch.KL];
    }

    private static void UPDATE_RKS(OPLL_SLOT S) {
        S.rks = rksTable[S.fnum >> 8][S.block][S.patch.KR];
    }

    private static void UPDATE_WF(OPLL_SLOT S) {
        S.sintbl = waveform[S.patch.WF];
    }

    private static void UPDATE_EG(OPLL_SLOT S) {
        S.eg_dphase = Emu2413.calc_eg_dphase(S);
    }

    private static void UPDATE_ALL(OPLL_SLOT S) {
        Emu2413.UPDATE_PG(S);
        Emu2413.UPDATE_TLL(S);
        Emu2413.UPDATE_RKS(S);
        Emu2413.UPDATE_WF(S);
        Emu2413.UPDATE_EG(S);
    }

    private static void slotOn(OPLL_SLOT slot) {
        slot.eg_mode = 1;
        slot.eg_phase = 0;
        slot.phase = 0;
        Emu2413.UPDATE_EG(slot);
    }

    private static void slotOn2(OPLL_SLOT slot) {
        slot.eg_mode = 1;
        slot.eg_phase = 0;
        Emu2413.UPDATE_EG(slot);
    }

    private static void slotOff(OPLL_SLOT slot) {
        if (slot.eg_mode == 1) {
            slot.eg_phase = Emu2413.EXPAND_BITS(AR_ADJUST_TABLE[Emu2413.HIGHBITS(slot.eg_phase, 15)], 7, 22);
        }
        slot.eg_mode = 5;
        Emu2413.UPDATE_EG(slot);
    }

    private static void keyOn(OPLL opll, int i) {
        if (!opll.slot_on_flag[i * 2]) {
            Emu2413.slotOn(Emu2413.MOD(opll, i));
        }
        if (!opll.slot_on_flag[i * 2 + 1]) {
            Emu2413.slotOn(Emu2413.CAR(opll, i));
        }
        opll.key_status[i] = true;
    }

    private static void keyOff(OPLL opll, int i) {
        if (opll.slot_on_flag[i * 2 + 1]) {
            Emu2413.slotOff(Emu2413.CAR(opll, i));
        }
        opll.key_status[i] = false;
    }

    private static void keyOn_BD(OPLL opll) {
        Emu2413.keyOn(opll, 6);
    }

    private static void keyOn_SD(OPLL opll) {
        if (!opll.slot_on_flag[15]) {
            Emu2413.slotOn(Emu2413.CAR(opll, 7));
        }
    }

    private static void keyOn_TOM(OPLL opll) {
        if (!opll.slot_on_flag[16]) {
            Emu2413.slotOn(Emu2413.MOD(opll, 8));
        }
    }

    private static void keyOn_HH(OPLL opll) {
        if (!opll.slot_on_flag[14]) {
            Emu2413.slotOn2(Emu2413.MOD(opll, 7));
        }
    }

    private static void keyOn_CYM(OPLL opll) {
        if (!opll.slot_on_flag[17]) {
            Emu2413.slotOn2(Emu2413.CAR(opll, 8));
        }
    }

    private static void keyOff_BD(OPLL opll) {
        Emu2413.keyOff(opll, 6);
    }

    private static void keyOff_SD(OPLL opll) {
        if (opll.slot_on_flag[15]) {
            Emu2413.slotOff(Emu2413.CAR(opll, 7));
        }
    }

    private static void keyOff_TOM(OPLL opll) {
        if (opll.slot_on_flag[16]) {
            Emu2413.slotOff(Emu2413.MOD(opll, 8));
        }
    }

    private static void keyOff_HH(OPLL opll) {
        if (opll.slot_on_flag[14]) {
            Emu2413.slotOff(Emu2413.MOD(opll, 7));
        }
    }

    private static void keyOff_CYM(OPLL opll) {
        if (opll.slot_on_flag[17]) {
            Emu2413.slotOff(Emu2413.CAR(opll, 8));
        }
    }

    private static void setPatch(OPLL opll, int i, int num) {
        opll.patch_number[i] = num;
        Emu2413.MOD((OPLL)opll, (int)i).patch = opll.patch[num * 2 + 0];
        Emu2413.CAR((OPLL)opll, (int)i).patch = opll.patch[num * 2 + 1];
    }

    private static void setSlotPatch(OPLL_SLOT slot, OPLL_PATCH patch) {
        slot.patch = patch;
    }

    private static void setSustine(OPLL opll, int c, boolean sustine) {
        Emu2413.CAR((OPLL)opll, (int)c).sustine = sustine;
        if (Emu2413.MOD((OPLL)opll, (int)c).type) {
            Emu2413.MOD((OPLL)opll, (int)c).sustine = sustine;
        }
    }

    private static void setVolume(OPLL opll, int c, int volume) {
        Emu2413.CAR((OPLL)opll, (int)c).volume = volume;
    }

    private static void setSlotVolume(OPLL_SLOT slot, int volume) {
        slot.volume = volume;
    }

    private static void setFnumber(OPLL opll, int c, int fnum) {
        Emu2413.CAR((OPLL)opll, (int)c).fnum = fnum;
        Emu2413.MOD((OPLL)opll, (int)c).fnum = fnum;
    }

    private static void setBlock(OPLL opll, int c, int block) {
        Emu2413.CAR((OPLL)opll, (int)c).block = block;
        Emu2413.MOD((OPLL)opll, (int)c).block = block;
    }

    private static void update_rhythm_mode(OPLL opll) {
        if ((opll.patch_number[6] & 0x10) != 0) {
            if (!opll.slot_on_flag[13] && (opll.reg[14] & 0x20) == 0) {
                opll.slot[12].eg_mode = 7;
                opll.slot[13].eg_mode = 7;
                Emu2413.setPatch(opll, 6, opll.reg[54] >> 4);
            }
        } else if ((opll.reg[14] & 0x20) != 0) {
            opll.patch_number[6] = 16;
            opll.slot[12].eg_mode = 7;
            opll.slot[13].eg_mode = 7;
            Emu2413.setSlotPatch(opll.slot[12], opll.patch[32]);
            Emu2413.setSlotPatch(opll.slot[13], opll.patch[33]);
        }
        if ((opll.patch_number[7] & 0x10) != 0) {
            if (!(opll.slot_on_flag[14] && opll.slot_on_flag[15] || (opll.reg[14] & 0x20) != 0)) {
                opll.slot[14].type = false;
                opll.slot[14].eg_mode = 7;
                opll.slot[15].eg_mode = 7;
                Emu2413.setPatch(opll, 7, opll.reg[55] >> 4);
            }
        } else if ((opll.reg[14] & 0x20) != 0) {
            opll.patch_number[7] = 17;
            opll.slot[14].type = true;
            opll.slot[14].eg_mode = 7;
            opll.slot[15].eg_mode = 7;
            Emu2413.setSlotPatch(opll.slot[14], opll.patch[34]);
            Emu2413.setSlotPatch(opll.slot[15], opll.patch[35]);
        }
        if ((opll.patch_number[8] & 0x10) != 0) {
            if (!(opll.slot_on_flag[17] && opll.slot_on_flag[16] || (opll.reg[14] & 0x20) != 0)) {
                opll.slot[16].type = false;
                opll.slot[16].eg_mode = 7;
                opll.slot[17].eg_mode = 7;
                Emu2413.setPatch(opll, 8, opll.reg[56] >> 4);
            }
        } else if ((opll.reg[14] & 0x20) != 0) {
            opll.patch_number[8] = 18;
            opll.slot[16].type = true;
            opll.slot[16].eg_mode = 7;
            opll.slot[17].eg_mode = 7;
            Emu2413.setSlotPatch(opll.slot[16], opll.patch[36]);
            Emu2413.setSlotPatch(opll.slot[17], opll.patch[37]);
        }
    }

    private static void update_key_status(OPLL opll) {
        for (int ch = 0; ch < 9; ++ch) {
            boolean bl = (opll.reg[32 + ch] & 0x10) != 0;
            opll.slot_on_flag[ch * 2 + 1] = bl;
            opll.slot_on_flag[ch * 2] = bl;
        }
        if ((opll.reg[14] & 0x20) != 0) {
            opll.slot_on_flag[12] = opll.slot_on_flag[12] | (opll.reg[14] & 0x10) != 0;
            opll.slot_on_flag[13] = opll.slot_on_flag[13] | (opll.reg[14] & 0x10) != 0;
            opll.slot_on_flag[15] = opll.slot_on_flag[15] | (opll.reg[14] & 8) != 0;
            opll.slot_on_flag[14] = opll.slot_on_flag[14] | (opll.reg[14] & 1) != 0;
            opll.slot_on_flag[16] = opll.slot_on_flag[16] | (opll.reg[14] & 4) != 0;
            opll.slot_on_flag[17] = opll.slot_on_flag[17] | (opll.reg[14] & 2) != 0;
        }
    }

    private static void OPLL_copyPatch(OPLL opll, int num, OPLL_PATCH patch) {
        OPLL_PATCH.copy(patch, opll.patch[num]);
    }

    private static void OPLL_SLOT_reset(OPLL_SLOT slot, boolean type) {
        slot.type = type;
        slot.sintbl = waveform[0];
        slot.phase = 0;
        slot.dphase = 0;
        slot.output[0] = 0;
        slot.output[1] = 0;
        slot.feedback = 0;
        slot.eg_mode = 7;
        slot.eg_phase = 0x400000;
        slot.eg_dphase = 0;
        slot.rks = 0;
        slot.tll = 0;
        slot.sustine = false;
        slot.fnum = 0;
        slot.block = 0;
        slot.volume = 0;
        slot.pgout = 0;
        slot.egout = 0;
        slot.patch = new OPLL_PATCH();
    }

    private static void internal_refresh() {
        Emu2413.makeDphaseTable();
        Emu2413.makeDphaseARTable();
        Emu2413.makeDphaseDRTable();
    }

    public static void OPLL_init() {
        Emu2413.makePmTable();
        Emu2413.makeAmTable();
        Emu2413.makeDB2LinTable();
        Emu2413.makeAdjustTable();
        Emu2413.makeTllTable();
        Emu2413.makeRksTable();
        Emu2413.makeSinTable();
        Emu2413.makeDefaultPatch();
        Emu2413.internal_refresh();
    }

    public static final OPLL OPLL_new() {
        OPLL opll = new OPLL();
        for (int i = 0; i < 38; ++i) {
            opll.patch[i] = new OPLL_PATCH();
        }
        Emu2413.OPLL_reset(opll);
        Emu2413.OPLL_reset_patch(opll);
        return opll;
    }

    public static final void OPLL_reset_patch(OPLL opll) {
        for (int i = 0; i < 38; ++i) {
            Emu2413.OPLL_copyPatch(opll, i, default_patch[i]);
        }
    }

    public static final void OPLL_reset(OPLL opll) {
        int i;
        if (opll == null) {
            return;
        }
        opll.adr = 0;
        opll.out = 0;
        opll.pm_phase = 0;
        opll.am_phase = 0;
        opll.noise_seed = 65535;
        for (i = 0; i < 18; ++i) {
            Emu2413.OPLL_SLOT_reset(opll.slot[i], (i & 1) != 0);
        }
        for (i = 0; i < 9; ++i) {
            opll.key_status[i] = false;
            Emu2413.setPatch(opll, i, 0);
        }
        for (i = 0; i < 64; ++i) {
            Emu2413.OPLL_writeReg(opll, i, 0);
        }
        opll.realstep = 43195;
        opll.opllstep = 43195;
        opll.oplltime = 0;
        for (i = 0; i < 14; ++i) {
            opll.pan[i] = 2;
        }
        opll.sprev[1] = 0;
        opll.sprev[0] = 0;
        opll.snext[1] = 0;
        opll.snext[0] = 0;
    }

    private static int wave2_4pi(int e) {
        return e << 2;
    }

    private static int wave2_8pi(int e) {
        return e << 3;
    }

    private static void update_ampm(OPLL opll) {
        opll.pm_phase = opll.pm_phase + 8 & 0xFFFF;
        opll.am_phase = opll.am_phase + 4 & 0xFFFF;
        opll.lfo_am = amtable[Emu2413.HIGHBITS(opll.am_phase, 8)];
        opll.lfo_pm = pmtable[Emu2413.HIGHBITS(opll.pm_phase, 8)];
    }

    private static void calc_phase(OPLL_SLOT slot, int lfo) {
        slot.phase = slot.patch.PM != 0 ? (slot.phase += slot.dphase * lfo >> 8) : (slot.phase += slot.dphase);
        slot.phase &= 0x3FFFF;
        slot.pgout = Emu2413.HIGHBITS(slot.phase, 9);
    }

    private static void update_noise(OPLL opll) {
        if ((opll.noise_seed & 1) != 0) {
            opll.noise_seed ^= 0x8003020;
        }
        opll.noise_seed >>= 1;
    }

    private static int S2E(double x) {
        return Emu2413.SL2EG((int)(x / 3.0)) << 15;
    }

    private static void calc_envelope(OPLL_SLOT slot, int lfo) {
        int egout;
        switch (slot.eg_mode) {
            case 1: {
                egout = AR_ADJUST_TABLE[Emu2413.HIGHBITS(slot.eg_phase, 15)];
                slot.eg_phase += slot.eg_dphase;
                if ((0x400000 & slot.eg_phase) == 0 && slot.patch.AR != 15) break;
                egout = 0;
                slot.eg_phase = 0;
                slot.eg_mode = 2;
                Emu2413.UPDATE_EG(slot);
                break;
            }
            case 2: {
                egout = Emu2413.HIGHBITS(slot.eg_phase, 15);
                slot.eg_phase += slot.eg_dphase;
                if (slot.eg_phase < SL[slot.patch.SL]) break;
                if (slot.patch.EG != 0) {
                    slot.eg_phase = SL[slot.patch.SL];
                    slot.eg_mode = 3;
                    Emu2413.UPDATE_EG(slot);
                    break;
                }
                slot.eg_phase = SL[slot.patch.SL];
                slot.eg_mode = 4;
                Emu2413.UPDATE_EG(slot);
                break;
            }
            case 3: {
                egout = Emu2413.HIGHBITS(slot.eg_phase, 15);
                if (slot.patch.EG != 0) break;
                slot.eg_mode = 4;
                Emu2413.UPDATE_EG(slot);
                break;
            }
            case 4: 
            case 5: {
                egout = Emu2413.HIGHBITS(slot.eg_phase, 15);
                slot.eg_phase += slot.eg_dphase;
                if (egout < 128) break;
                slot.eg_mode = 7;
                egout = 127;
                break;
            }
            case 6: {
                egout = Emu2413.HIGHBITS(slot.eg_phase, 15);
                slot.eg_phase += slot.eg_dphase;
                if (egout < 128) break;
                slot.eg_mode = 1;
                egout = 127;
                Emu2413.UPDATE_EG(slot);
                break;
            }
            case 7: {
                egout = 127;
                break;
            }
            default: {
                egout = 127;
            }
        }
        if ((egout = slot.patch.AM != 0 ? Emu2413.EG2DB(egout + slot.tll) + lfo : Emu2413.EG2DB(egout + slot.tll)) >= 256) {
            egout = 255;
        }
        slot.egout = egout | 3;
    }

    private static int calc_slot_car(OPLL_SLOT slot, int fm) {
        slot.output[0] = slot.egout >= 255 ? 0 : DB2LIN_TABLE[slot.sintbl[slot.pgout + Emu2413.wave2_8pi(fm) & 0x1FF] + slot.egout];
        slot.output[1] = slot.output[1] + slot.output[0] >> 1;
        return slot.output[1];
    }

    private static int calc_slot_mod(OPLL_SLOT slot) {
        slot.output[1] = slot.output[0];
        if (slot.egout >= 255) {
            slot.output[0] = 0;
        } else if (slot.patch.FB != 0) {
            int fm = Emu2413.wave2_4pi(slot.feedback) >> 7 - slot.patch.FB;
            slot.output[0] = DB2LIN_TABLE[slot.sintbl[slot.pgout + fm & 0x1FF] + slot.egout];
        } else {
            slot.output[0] = DB2LIN_TABLE[slot.sintbl[slot.pgout] + slot.egout];
        }
        slot.feedback = slot.output[1] + slot.output[0] >> 1;
        return slot.feedback;
    }

    private static int calc_slot_tom(OPLL_SLOT slot) {
        if (slot.egout >= 255) {
            return 0;
        }
        return DB2LIN_TABLE[slot.sintbl[slot.pgout] + slot.egout];
    }

    private static int calc_slot_snare(OPLL_SLOT slot, boolean noise) {
        if (slot.egout >= 255) {
            return 0;
        }
        if (Emu2413.BIT(slot.pgout, 7)) {
            return DB2LIN_TABLE[(noise ? Emu2413.DB_POS(0.0) : Emu2413.DB_POS(15.0)) + slot.egout];
        }
        return DB2LIN_TABLE[(noise ? Emu2413.DB_NEG(0.0) : Emu2413.DB_NEG(15.0)) + slot.egout];
    }

    private static int calc_slot_cym(OPLL_SLOT slot, int pgout_hh) {
        if (slot.egout >= 255) {
            return 0;
        }
        int dbout = (Emu2413.BIT(pgout_hh, 1) ^ Emu2413.BIT(pgout_hh, 8) | Emu2413.BIT(pgout_hh, 2)) ^ Emu2413.BIT(slot.pgout, 2) & !Emu2413.BIT(slot.pgout, 4) ? Emu2413.DB_NEG(3.0) : Emu2413.DB_POS(3.0);
        return DB2LIN_TABLE[dbout + slot.egout];
    }

    private static int calc_slot_hat(OPLL_SLOT slot, int pgout_cym, boolean noise) {
        if (slot.egout >= 255) {
            return 0;
        }
        int dbout = (Emu2413.BIT(slot.pgout, 1) ^ Emu2413.BIT(slot.pgout, 8) | Emu2413.BIT(slot.pgout, 2)) ^ Emu2413.BIT(pgout_cym, 2) & !Emu2413.BIT(pgout_cym, 4) ? (noise ? Emu2413.DB_NEG(12.0) : Emu2413.DB_NEG(24.0)) : (noise ? Emu2413.DB_POS(12.0) : Emu2413.DB_POS(24.0));
        return DB2LIN_TABLE[dbout + slot.egout];
    }

    private static int calc(OPLL opll) {
        int i;
        int inst = 0;
        int perc = 0;
        Emu2413.update_ampm(opll);
        Emu2413.update_noise(opll);
        for (i = 0; i < 18; ++i) {
            Emu2413.calc_phase(opll.slot[i], opll.lfo_pm);
            Emu2413.calc_envelope(opll.slot[i], opll.lfo_am);
        }
        for (i = 0; i < 6; ++i) {
            if (Emu2413.CAR((OPLL)opll, (int)i).eg_mode == 7) continue;
            inst += Emu2413.calc_slot_car(Emu2413.CAR(opll, i), Emu2413.calc_slot_mod(Emu2413.MOD(opll, i)));
        }
        if (opll.patch_number[6] <= 15) {
            if (Emu2413.CAR((OPLL)opll, (int)6).eg_mode != 7) {
                inst += Emu2413.calc_slot_car(Emu2413.CAR(opll, 6), Emu2413.calc_slot_mod(Emu2413.MOD(opll, 6)));
            }
        } else if (Emu2413.CAR((OPLL)opll, (int)6).eg_mode != 7) {
            perc += Emu2413.calc_slot_car(Emu2413.CAR(opll, 6), Emu2413.calc_slot_mod(Emu2413.MOD(opll, 6)));
        }
        if (opll.patch_number[7] <= 15) {
            if (Emu2413.CAR((OPLL)opll, (int)7).eg_mode != 7) {
                inst += Emu2413.calc_slot_car(Emu2413.CAR(opll, 7), Emu2413.calc_slot_mod(Emu2413.MOD(opll, 7)));
            }
        } else {
            if (Emu2413.MOD((OPLL)opll, (int)7).eg_mode != 7) {
                perc += Emu2413.calc_slot_hat(Emu2413.MOD(opll, 7), Emu2413.CAR((OPLL)opll, (int)8).pgout, (opll.noise_seed & 1) != 0);
            }
            if (Emu2413.CAR((OPLL)opll, (int)7).eg_mode != 7) {
                perc -= Emu2413.calc_slot_snare(Emu2413.CAR(opll, 7), (opll.noise_seed & 1) != 0);
            }
        }
        if (opll.patch_number[8] <= 15) {
            if (Emu2413.CAR((OPLL)opll, (int)8).eg_mode != 7) {
                inst += Emu2413.calc_slot_car(Emu2413.CAR(opll, 8), Emu2413.calc_slot_mod(Emu2413.MOD(opll, 8)));
            }
        } else {
            if (Emu2413.MOD((OPLL)opll, (int)8).eg_mode != 7) {
                perc += Emu2413.calc_slot_tom(Emu2413.MOD(opll, 8));
            }
            if (Emu2413.CAR((OPLL)opll, (int)8).eg_mode != 7) {
                perc -= Emu2413.calc_slot_cym(Emu2413.CAR(opll, 8), Emu2413.MOD((OPLL)opll, (int)7).pgout);
            }
        }
        return inst + (perc << 1) << 3;
    }

    public static int OPLL_calc(OPLL opll) {
        while (opll.realstep > opll.oplltime) {
            opll.oplltime += opll.opllstep;
            opll.prev = opll.next;
            opll.next = Emu2413.calc(opll);
        }
        opll.oplltime -= opll.realstep;
        opll.out = (int)(((double)opll.next * (double)(opll.opllstep - opll.oplltime) + (double)opll.prev * (double)opll.oplltime) / (double)opll.opllstep);
        return opll.out;
    }

    private static void OPLL_writeReg(OPLL opll, int reg, int data) {
        opll.reg[reg &= 0x3F] = data &= 0xFF;
        switch (reg) {
            case 0: {
                opll.patch[0].AM = data >> 7 & 1;
                opll.patch[0].PM = data >> 6 & 1;
                opll.patch[0].EG = data >> 5 & 1;
                opll.patch[0].KR = data >> 4 & 1;
                opll.patch[0].ML = data & 0xF;
                for (int i = 0; i < 9; ++i) {
                    if (opll.patch_number[i] != 0) continue;
                    Emu2413.UPDATE_PG(Emu2413.MOD(opll, i));
                    Emu2413.UPDATE_RKS(Emu2413.MOD(opll, i));
                    Emu2413.UPDATE_EG(Emu2413.MOD(opll, i));
                }
                break;
            }
            case 1: {
                opll.patch[1].AM = data >> 7 & 1;
                opll.patch[1].PM = data >> 6 & 1;
                opll.patch[1].EG = data >> 5 & 1;
                opll.patch[1].KR = data >> 4 & 1;
                opll.patch[1].ML = data & 0xF;
                for (int i = 0; i < 9; ++i) {
                    if (opll.patch_number[i] != 0) continue;
                    Emu2413.UPDATE_PG(Emu2413.CAR(opll, i));
                    Emu2413.UPDATE_RKS(Emu2413.CAR(opll, i));
                    Emu2413.UPDATE_EG(Emu2413.CAR(opll, i));
                }
                break;
            }
            case 2: {
                opll.patch[0].KL = data >> 6 & 3;
                opll.patch[0].TL = data & 0x3F;
                for (int i = 0; i < 9; ++i) {
                    if (opll.patch_number[i] != 0) continue;
                    Emu2413.UPDATE_TLL(Emu2413.MOD(opll, i));
                }
                break;
            }
            case 3: {
                opll.patch[1].KL = data >> 6 & 3;
                opll.patch[1].WF = data >> 4 & 1;
                opll.patch[0].WF = data >> 3 & 1;
                opll.patch[0].FB = data & 7;
                for (int i = 0; i < 9; ++i) {
                    if (opll.patch_number[i] != 0) continue;
                    Emu2413.UPDATE_WF(Emu2413.MOD(opll, i));
                    Emu2413.UPDATE_WF(Emu2413.CAR(opll, i));
                }
                break;
            }
            case 4: {
                opll.patch[0].AR = data >> 4 & 0xF;
                opll.patch[0].DR = data & 0xF;
                for (int i = 0; i < 9; ++i) {
                    if (opll.patch_number[i] != 0) continue;
                    Emu2413.UPDATE_EG(Emu2413.MOD(opll, i));
                }
                break;
            }
            case 5: {
                opll.patch[1].AR = data >> 4 & 0xF;
                opll.patch[1].DR = data & 0xF;
                for (int i = 0; i < 9; ++i) {
                    if (opll.patch_number[i] != 0) continue;
                    Emu2413.UPDATE_EG(Emu2413.CAR(opll, i));
                }
                break;
            }
            case 6: {
                opll.patch[0].SL = data >> 4 & 0xF;
                opll.patch[0].RR = data & 0xF;
                for (int i = 0; i < 9; ++i) {
                    if (opll.patch_number[i] != 0) continue;
                    Emu2413.UPDATE_EG(Emu2413.MOD(opll, i));
                }
                break;
            }
            case 7: {
                opll.patch[1].SL = data >> 4 & 0xF;
                opll.patch[1].RR = data & 0xF;
                for (int i = 0; i < 9; ++i) {
                    if (opll.patch_number[i] != 0) continue;
                    Emu2413.UPDATE_EG(Emu2413.CAR(opll, i));
                }
                break;
            }
            case 14: {
                Emu2413.update_rhythm_mode(opll);
                if ((data & 0x20) != 0) {
                    if ((data & 0x10) != 0) {
                        Emu2413.keyOn_BD(opll);
                    } else {
                        Emu2413.keyOff_BD(opll);
                    }
                    if ((data & 8) != 0) {
                        Emu2413.keyOn_SD(opll);
                    } else {
                        Emu2413.keyOff_SD(opll);
                    }
                    if ((data & 4) != 0) {
                        Emu2413.keyOn_TOM(opll);
                    } else {
                        Emu2413.keyOff_TOM(opll);
                    }
                    if ((data & 2) != 0) {
                        Emu2413.keyOn_CYM(opll);
                    } else {
                        Emu2413.keyOff_CYM(opll);
                    }
                    if ((data & 1) != 0) {
                        Emu2413.keyOn_HH(opll);
                    } else {
                        Emu2413.keyOff_HH(opll);
                    }
                }
                Emu2413.update_key_status(opll);
                Emu2413.UPDATE_ALL(Emu2413.MOD(opll, 6));
                Emu2413.UPDATE_ALL(Emu2413.CAR(opll, 6));
                Emu2413.UPDATE_ALL(Emu2413.MOD(opll, 7));
                Emu2413.UPDATE_ALL(Emu2413.CAR(opll, 7));
                Emu2413.UPDATE_ALL(Emu2413.MOD(opll, 8));
                Emu2413.UPDATE_ALL(Emu2413.CAR(opll, 8));
                break;
            }
            case 15: {
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                int ch = reg - 16;
                Emu2413.setFnumber(opll, ch, data + ((opll.reg[32 + ch] & 1) << 8));
                Emu2413.UPDATE_ALL(Emu2413.MOD(opll, ch));
                Emu2413.UPDATE_ALL(Emu2413.CAR(opll, ch));
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                int ch = reg - 32;
                Emu2413.setFnumber(opll, ch, ((data & 1) << 8) + opll.reg[16 + ch]);
                Emu2413.setBlock(opll, ch, data >> 1 & 7);
                Emu2413.setSustine(opll, ch, (data >> 5 & 1) != 0);
                if ((data & 0x10) != 0) {
                    Emu2413.keyOn(opll, ch);
                } else {
                    Emu2413.keyOff(opll, ch);
                }
                Emu2413.UPDATE_ALL(Emu2413.MOD(opll, ch));
                Emu2413.UPDATE_ALL(Emu2413.CAR(opll, ch));
                Emu2413.update_key_status(opll);
                Emu2413.update_rhythm_mode(opll);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                int i = data >> 4 & 0xF;
                int v = data & 0xF;
                if ((opll.reg[14] & 0x20) != 0 && reg >= 54) {
                    switch (reg) {
                        case 55: {
                            Emu2413.setSlotVolume(Emu2413.MOD(opll, 7), i << 2);
                            break;
                        }
                        case 56: {
                            Emu2413.setSlotVolume(Emu2413.MOD(opll, 8), i << 2);
                        }
                    }
                } else {
                    Emu2413.setPatch(opll, reg - 48, i);
                }
                Emu2413.setVolume(opll, reg - 48, v << 2);
                Emu2413.UPDATE_ALL(Emu2413.MOD(opll, reg - 48));
                Emu2413.UPDATE_ALL(Emu2413.CAR(opll, reg - 48));
                break;
            }
        }
    }

    public static final void OPLL_writeIO(OPLL opll, int adr, int val) {
        if ((adr & 1) != 0) {
            Emu2413.OPLL_writeReg(opll, opll.adr, val);
        } else {
            opll.adr = val;
        }
    }

    private Emu2413() {
    }
}

