/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.konami.vrc6;

import nintaco.mappers.konami.vrc6.VrcChannel;

public class VrcSawtoothGenerator
extends VrcChannel {
    private static final long serialVersionUID = 0L;
    private int accumulator;
    private int accumulatorRate;
    private int accumulatorClocks;
    private boolean clockAccumulator;

    public void reset() {
        this.accumulator = 0;
        this.accumulatorRate = 0;
        this.accumulatorClocks = 0;
        this.clockAccumulator = false;
    }

    public void writeAccumulatorRate(int value) {
        this.accumulatorRate = 0x3F & value;
    }

    public void update() {
        if (this.runOscillator) {
            if (this.frequency == 0) {
                this.frequency = this.frequencyReload >> this.frequencyShift;
                if (this.clockAccumulator && this.enabled) {
                    if (++this.accumulatorClocks == 7) {
                        this.accumulator = 0;
                        this.accumulatorClocks = 0;
                    } else {
                        this.accumulator = 0xFF & this.accumulator + this.accumulatorRate;
                    }
                    this.outputLevel = this.accumulator >> 3;
                }
                this.clockAccumulator = !this.clockAccumulator;
            } else {
                --this.frequency;
            }
        }
    }

    @Override
    public void writeFrequencyHigh(int value) {
        super.writeFrequencyHigh(value);
        if (!this.enabled) {
            this.accumulator = 0;
            this.outputLevel = 0;
        }
    }
}

