/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.konami.vrc6;

import nintaco.files.CartFile;
import nintaco.mappers.konami.VrcIrq;
import nintaco.mappers.konami.vrc6.VRC6Audio;
import nintaco.util.BitUtil;

public class VRC6a
extends VrcIrq {
    private static final long serialVersionUID = 0L;
    protected final int[] R = new int[8];
    protected final VRC6Audio audio = new VRC6Audio();
    protected int B003;
    protected boolean chrRomNametables;
    protected boolean chrA10;
    protected boolean prgRamEnabled;

    public VRC6a(CartFile cartFile) {
        super(cartFile, 8, 12);
        this.setPrgBank(7, -1);
    }

    @Override
    public int readVRAM(int address) {
        if (address < 12288) {
            if (address < 8192) {
                if (this.chrRamPresent) {
                    return this.vram[address];
                }
                return this.chrROM[this.chrBanks[address >> 10] | address & 0x3FF];
            }
            if (this.chrRomNametables) {
                if (this.chrRamPresent) {
                    return this.vram[address];
                }
                return this.chrROM[this.chrBanks[address >> 10] | address & 0x3FF];
            }
            return this.vram[address];
        }
        return this.vram[address];
    }

    protected int adjustAddress(int address) {
        return address & 0xF003;
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address < 24576 || address >= 32768 || this.prgRamEnabled) {
            this.memory[address] = value;
        }
        if (address >= 32768) {
            this.writeRegister(address, value);
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (this.audio.writeRegister(address, value)) {
            return;
        }
        switch (this.adjustAddress(address)) {
            case 32768: 
            case 32769: 
            case 32770: 
            case 32771: {
                this.write16KPrgSelect(value);
                break;
            }
            case 45059: {
                this.writePPUBankingStyle(value);
                break;
            }
            case 49152: 
            case 49153: 
            case 49154: 
            case 49155: {
                this.write8KPrgSelect(value);
                break;
            }
            case 53248: {
                this.writeChrSelect(0, value);
                break;
            }
            case 53249: {
                this.writeChrSelect(1, value);
                break;
            }
            case 53250: {
                this.writeChrSelect(2, value);
                break;
            }
            case 53251: {
                this.writeChrSelect(3, value);
                break;
            }
            case 57344: {
                this.writeChrSelect(4, value);
                break;
            }
            case 57345: {
                this.writeChrSelect(5, value);
                break;
            }
            case 57346: {
                this.writeChrSelect(6, value);
                break;
            }
            case 57347: {
                this.writeChrSelect(7, value);
                break;
            }
            case 61440: {
                this.writeIrqLatch(value);
                break;
            }
            case 61441: {
                this.writeIrqControl(value);
                break;
            }
            case 61442: {
                this.writeIrqAcknowledge();
            }
        }
    }

    protected void write16KPrgSelect(int value) {
        value = (value & 0xF) << 1;
        this.setPrgBank(4, value);
        this.setPrgBank(5, value | 1);
    }

    protected void write8KPrgSelect(int value) {
        this.setPrgBank(6, value & 0x1F);
    }

    protected void writePPUBankingStyle(int value) {
        this.B003 = value;
        this.chrRomNametables = BitUtil.getBitBool(value, 4);
        this.chrA10 = BitUtil.getBitBool(value, 5);
        this.prgRamEnabled = BitUtil.getBitBool(value, 7);
        this.updateChrBanks();
        this.updateNametables();
    }

    protected void writeChrSelect(int register, int value) {
        this.R[register] = value;
        this.updateChrBanks();
    }

    protected void setChrBank1K(int bank, int register) {
        this.chrBanks[bank] = register << 10;
    }

    protected void setChrBank2K(int bank, int register) {
        int value = this.R[register];
        value = this.chrA10 ? (value &= 0xFE) : (value <<= 1);
        this.setChrBank1K(bank, value);
        this.setChrBank1K(bank + 1, value | 1);
    }

    protected void updateChrBanks() {
        switch (this.B003 & 3) {
            case 0: {
                for (int i = 7; i >= 0; --i) {
                    this.setChrBank1K(i, this.R[i]);
                }
                break;
            }
            case 1: {
                for (int i = 3; i >= 0; --i) {
                    this.setChrBank2K(i << 1, i);
                }
                break;
            }
            case 2: 
            case 3: {
                for (int i = 3; i >= 0; --i) {
                    this.setChrBank1K(i, this.R[i]);
                }
                this.setChrBank2K(4, 4);
                this.setChrBank2K(6, 5);
            }
        }
    }

    protected void updateNametables() {
        switch (this.B003 & 7) {
            case 0: 
            case 6: 
            case 7: {
                this.setChrBank1K(8, 6);
                this.setChrBank1K(9, 6);
                this.setChrBank1K(10, 7);
                this.setChrBank1K(11, 7);
                break;
            }
            case 1: 
            case 5: {
                this.setChrBank1K(8, 4);
                this.setChrBank1K(9, 5);
                this.setChrBank1K(10, 6);
                this.setChrBank1K(11, 7);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.setChrBank1K(8, 6);
                this.setChrBank1K(9, 7);
                this.setChrBank1K(10, 6);
                this.setChrBank1K(11, 7);
            }
        }
        if (this.chrA10) {
            switch (this.B003 & 0xF) {
                case 0: 
                case 7: {
                    this.setNametableMirroring(0);
                    break;
                }
                case 3: 
                case 4: {
                    this.setNametableMirroring(1);
                    break;
                }
                case 8: 
                case 15: {
                    this.setNametableMirroring(2);
                    break;
                }
                case 11: 
                case 12: {
                    this.setNametableMirroring(3);
                    break;
                }
                default: {
                    this.setNametableMirroring(4);
                    break;
                }
            }
        } else {
            this.setNametableMirroring(4);
        }
    }

    @Override
    public float getAudioSample() {
        return this.audio.getAudioSample();
    }

    @Override
    public int getAudioMixerScale() {
        return this.audio.getAudioMixerScale();
    }

    @Override
    public void update() {
        super.update();
        this.audio.update();
    }
}

