/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.konami;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public abstract class VrcIrq
extends Mapper {
    private static final long serialVersionUID = 0L;
    protected int irqLatch;
    protected boolean irqCycleMode;
    protected boolean irqEnabled;
    protected boolean irqEnableAfterAck;
    protected int irqCounter;
    protected float scanlineCycleCounter = 341.0f;
    protected float scanlineDelta;

    public VrcIrq(CartFile cartFile) {
        this(cartFile, 8, 8);
    }

    public VrcIrq(CartFile cartFile, int prgBanksSize, int chrBanksSize) {
        super(cartFile, prgBanksSize, chrBanksSize);
    }

    @Override
    public void init() {
        this.scanlineDelta = this.ntsc ? 3.0f : 3.2f;
    }

    protected void writeIrqLatchLow(int value) {
        this.irqLatch = this.irqLatch & 0xF0 | value & 0xF;
    }

    protected void writeIrqLatchHigh(int value) {
        this.irqLatch = this.irqLatch & 0xF | (value & 0xF) << 4;
    }

    protected void writeIrqLatch(int value) {
        this.irqLatch = value;
    }

    protected void writeIrqControl(int value) {
        this.irqEnableAfterAck = BitUtil.getBitBool(value, 0);
        this.irqEnabled = BitUtil.getBitBool(value, 1);
        this.irqCycleMode = BitUtil.getBitBool(value, 2);
        this.cpu.setMapperIrq(false);
        if (this.irqEnabled) {
            this.irqCounter = this.irqLatch;
            this.scanlineCycleCounter = 341.0f;
        }
    }

    protected void writeIrqAcknowledge() {
        this.cpu.setMapperIrq(false);
        this.irqEnabled = this.irqEnableAfterAck;
    }

    protected void clockIrqCounter() {
        if (this.irqCounter == 255) {
            this.irqCounter = this.irqLatch;
            this.cpu.setMapperIrq(true);
        } else {
            ++this.irqCounter;
        }
    }

    @Override
    public void update() {
        if (this.irqEnabled) {
            if (this.irqCycleMode) {
                this.clockIrqCounter();
            } else {
                this.scanlineCycleCounter -= this.scanlineDelta;
                if (this.scanlineCycleCounter <= 0.0f) {
                    this.scanlineCycleCounter += 341.0f;
                    this.clockIrqCounter();
                }
            }
        }
    }
}

