/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.kaiser;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Kaiser7057
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[8];

    public Kaiser7057(CartFile cartFile) {
        super(cartFile, 32, 1, 32768, 24576);
    }

    @Override
    public void init() {
        this.setChrBank(0);
        for (int i = 20; i <= 31; ++i) {
            this.setPrgBank(i, 32 + i);
        }
        this.updateBanks();
    }

    private void updateBanks() {
        for (int i = 3; i >= 0; --i) {
            this.setPrgBank(i + 12, this.regs[i + 4]);
            this.setPrgBank(i + 16, this.regs[i]);
        }
    }

    private void setReg(int index, int value, boolean low) {
        this.regs[index] = low ? this.regs[index] & 0xF0 | value & 0xF : this.regs[index] & 0xF | value << 4 & 0xF0;
        this.updateBanks();
    }

    @Override
    protected void writeRegister(int address, int value) {
        boolean low = (address & 1) == 0;
        switch (address & 0xF002) {
            case 32768: 
            case 32770: 
            case 36864: 
            case 36866: {
                this.setNametableMirroring(value & 1 ^ 1);
                break;
            }
            case 45056: {
                this.setReg(0, value, low);
                break;
            }
            case 45058: {
                this.setReg(1, value, low);
                break;
            }
            case 49152: {
                this.setReg(2, value, low);
                break;
            }
            case 49154: {
                this.setReg(3, value, low);
                break;
            }
            case 53248: {
                this.setReg(4, value, low);
                break;
            }
            case 53250: {
                this.setReg(5, value, low);
                break;
            }
            case 57344: {
                this.setReg(6, value, low);
                break;
            }
            case 57346: {
                this.setReg(7, value, low);
            }
        }
    }
}

