/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.jy;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper356
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private int prgRomOffset;
    private int prgRomMask;
    private int chrRomOffset;
    private int chrRomMask;
    private int regNum;
    private int prgMask;
    private int prgOffset;
    private int chrMask;
    private int chrOffset;
    private int mirroring;
    private boolean locked;
    private boolean chrRomMode;
    private boolean vramMode;

    public Mapper356(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.regNum = 0;
        this.chrOffset = 0;
        this.prgOffset = 0;
        this.chrRomOffset = 0;
        this.prgRomOffset = 0;
        this.chrRomMask = -1;
        this.prgRomMask = -1;
        this.prgMask = 63;
        this.chrMask = 255;
        this.vramMode = false;
        this.chrRomMode = false;
        this.locked = false;
        this.updateState();
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updateState() {
        this.setPrgBlock(this.prgOffset, this.prgMask);
        if (this.chrRomMode) {
            this.setChrBlock(this.chrOffset, this.chrMask);
            this.chrRamPresent = false;
        } else {
            this.setChrBlock(0, -1);
            this.chrRamPresent = true;
        }
        if (this.vramMode) {
            this.setNametableMirroring(4);
        } else {
            super.writeMirroring(this.mirroring);
        }
        this.chrRomOffset = this.chrOffset << 10;
        this.prgRomMask = (this.prgMask + 1 << 13) - 1;
        this.chrRomMask = (this.chrMask + 1 << 10) - 1;
        this.updateBanks();
    }

    private void writeReg(int value) {
        if (!this.locked) {
            switch (this.regNum++ & 3) {
                case 0: {
                    this.chrOffset = this.chrOffset & 0xFFFFFF00 | value;
                    break;
                }
                case 1: {
                    this.prgOffset = this.prgOffset & 0xFFFFFF00 | value;
                    this.prgRomOffset = this.prgOffset << 13;
                    break;
                }
                case 2: {
                    this.chrMask = 255 >> (~value & 0xF);
                    this.chrOffset = this.chrOffset & 0xFF | (value & 0xF0) << 4;
                    this.prgOffset = this.prgOffset & 0xFF | (value & 0xC0) << 2;
                    this.chrRomMode = BitUtil.getBitBool(value, 5);
                    this.vramMode = BitUtil.getBitBool(value, 6);
                    break;
                }
                case 3: {
                    this.prgMask = ~value & 0x3F;
                    this.locked = BitUtil.getBitBool(value, 6);
                }
            }
            this.updateState();
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xE000) == 24576) {
            this.writeReg(value);
        }
        super.writeMemory(address, value);
    }

    @Override
    public int readMemory(int address) {
        if (address >= this.minRomAddress) {
            return this.prgROM[(this.prgRomOffset | (this.prgBanks[address >> this.prgShift] | address & this.prgAddressMask) & this.prgRomMask) & this.prgRomSizeMask];
        }
        return this.memory[address];
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192 && this.chrAddressMask != 0) {
            if (this.chrRamPresent) {
                return (this.xChrRam != null ? this.xChrRam : this.vram)[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRamSizeMask];
            }
            return this.chrROM[(this.chrRomOffset | (this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRomMask) & this.chrRomSizeMask];
        }
        return this.vram[address];
    }

    @Override
    protected void writeMirroring(int value) {
        this.mirroring = value;
        this.updateState();
    }
}

