/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.jy;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class Mapper091
extends MMC3 {
    private static final long serialVersionUID = 0L;

    public Mapper091(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.prgBanks[6] = this.prgROM.length - 16384;
        this.prgBanks[7] = this.prgROM.length - 8192;
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address >= 24576) {
            switch (address & 0xF003) {
                case 24576: {
                    this.writeChrReg(0, value);
                    break;
                }
                case 24577: {
                    this.writeChrReg(2, value);
                    break;
                }
                case 24578: {
                    this.writeChrReg(4, value);
                    break;
                }
                case 24579: {
                    this.writeChrReg(6, value);
                    break;
                }
                case 28672: {
                    this.writePrgReg(4, value);
                    break;
                }
                case 28673: {
                    this.writePrgReg(5, value);
                    break;
                }
                case 28674: {
                    this.writeIrqDisable();
                    break;
                }
                case 28675: {
                    this.writeIrqLatch(7);
                    this.writeIrqReload();
                    this.writeIrqEnable();
                }
            }
        } else {
            this.memory[address] = value;
        }
    }

    protected void writePrgReg(int register, int value) {
        this.prgBanks[register] = value << 13;
    }

    protected void writeChrReg(int register, int value) {
        this.chrBanks[register] = value << 11;
        this.chrBanks[register + 1] = this.chrBanks[register] + 1024;
    }
}

