/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.jaleco;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class SS88006
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int[][] IRQ_MASKS = new int[][]{{65535, 0}, {4095, 61440}, {255, 65280}, {15, 65520}};
    private int irqSize;
    private int irqCounter;
    private int irqReload;
    private boolean irqEnabled;

    public SS88006(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    @Override
    public void init() {
        this.setPrgBank(7, -1);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address >= 40960 && address < 57344) {
            this.writeChrBank(address, value);
        } else {
            switch (address & 0xF003) {
                case 32768: {
                    this.writePrgBankLow(4, value);
                    break;
                }
                case 32769: {
                    this.writePrgBankHigh(4, value);
                    break;
                }
                case 32770: {
                    this.writePrgBankLow(5, value);
                    break;
                }
                case 32771: {
                    this.writePrgBankHigh(5, value);
                    break;
                }
                case 36864: {
                    this.writePrgBankLow(6, value);
                    break;
                }
                case 36865: {
                    this.writePrgBankHigh(6, value);
                    break;
                }
                case 57344: 
                case 57345: 
                case 57346: 
                case 57347: {
                    this.writeIrqReload(address, value);
                    break;
                }
                case 61440: {
                    this.writeIrqReset();
                    break;
                }
                case 61441: {
                    this.writeIrqControl(value);
                    break;
                }
                case 61442: {
                    this.writeMirroring(value);
                    break;
                }
            }
        }
    }

    private void writeMirroring(int value) {
        switch (value & 3) {
            case 0: {
                this.setNametableMirroring(1);
                break;
            }
            case 1: {
                this.setNametableMirroring(0);
                break;
            }
            case 2: {
                this.setNametableMirroring(2);
                break;
            }
            case 3: {
                this.setNametableMirroring(3);
            }
        }
    }

    private void writeIrqReset() {
        this.irqCounter = this.irqReload;
        this.cpu.setMapperIrq(false);
    }

    private void writeIrqControl(int value) {
        this.irqEnabled = BitUtil.getBitBool(value, 0);
        this.irqSize = BitUtil.getBitBool(value, 3) ? 3 : (BitUtil.getBitBool(value, 2) ? 2 : (BitUtil.getBitBool(value, 1) ? 1 : 0));
        this.cpu.setMapperIrq(false);
    }

    private void writeIrqReload(int address, int value) {
        int shift = (address & 3) << 2;
        this.irqReload = this.irqReload & ~(15 << shift) | (value & 0xF) << shift;
    }

    private void writeChrBank(int address, int value) {
        int bank = (address >> 12) - 10 << 1 | address >> 1 & 1;
        int shift = (address & 1) << 2;
        this.chrBanks[bank] = this.chrBanks[bank] & 245760 >> shift | (value & 0xF) << 10 + shift;
    }

    private void writePrgBankLow(int bank, int value) {
        this.prgBanks[bank] = this.prgBanks[bank] & 0x1E0000 | (value & 0xF) << 13;
    }

    private void writePrgBankHigh(int bank, int value) {
        this.prgBanks[bank] = this.prgBanks[bank] & 0x1E000 | (value & 0xF) << 17;
    }

    @Override
    public void update() {
        if (this.irqEnabled) {
            if ((this.irqCounter & IRQ_MASKS[this.irqSize][0]) == 0) {
                this.cpu.setMapperIrq(true);
            }
            this.irqCounter = this.irqCounter & IRQ_MASKS[this.irqSize][1] | this.irqCounter - 1 & IRQ_MASKS[this.irqSize][0];
        }
    }
}

