/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.irem;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class G101
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] prgRegs = new int[2];
    private final boolean G101B;
    private boolean prgMode;

    public G101(CartFile cartFile) {
        super(cartFile, 8, 8);
        if (cartFile.getFileCRC() == 607815477 || cartFile.getSubmapperNumber() == 1) {
            this.G101B = true;
            this.setNametableMirroring(2);
        } else {
            this.G101B = false;
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xF000) {
            case 32768: {
                this.writePrgRegister(0, value);
                break;
            }
            case 36864: {
                this.writePrgMode(value);
                break;
            }
            case 40960: {
                this.writePrgRegister(1, value);
                break;
            }
            case 45056: {
                this.setChrBank(address & 7, value);
            }
        }
    }

    private void writePrgRegister(int register, int value) {
        this.prgRegs[register] = value & 0x1F;
        this.updatePrgBanks();
    }

    private void writePrgMode(int value) {
        this.prgMode = !this.G101B && BitUtil.getBitBool(value, 1);
        this.setNametableMirroring(BitUtil.getBit(value, 0));
        this.updatePrgBanks();
    }

    private void updatePrgBanks() {
        if (this.prgMode) {
            this.setPrgBank(4, -2);
            this.setPrgBank(6, this.prgRegs[0]);
        } else {
            this.setPrgBank(4, this.prgRegs[0]);
            this.setPrgBank(6, -2);
        }
        this.setPrgBank(5, this.prgRegs[1]);
        this.setPrgBank(7, -1);
    }
}

