/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.homebrew;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Glider
extends Mapper {
    private static final long serialVersionUID = 0L;

    public Glider(CartFile cartFile) {
        super(cartFile, 4, 1);
        this.xram = new int[32768];
        this.setPrgBank(3, -1);
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.setChrBank(value & 7);
        this.prgBanks[2] = (value & 0x1C) << 12;
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            return this.xram[this.chrBanks[0] | address];
        }
        return this.vram[address];
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (address < 8192) {
            this.xram[this.chrBanks[0] | address] = value;
        } else {
            this.vram[address] = value;
        }
    }
}

