/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.frontfareast;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class FrontFareast
extends Mapper {
    private static final long serialVersionUID = 0L;
    protected int irqCounter;
    protected boolean irqEnabled;
    protected boolean ffeAltMode;

    public FrontFareast(CartFile cartFile) {
        super(cartFile, 8, 8);
        this.xram = this.chrRamPresent ? new int[32768] : null;
    }

    @Override
    public void init() {
        this.irqCounter = 0;
        this.irqEnabled = false;
        this.ffeAltMode = true;
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (address < 8192 && this.chrRamPresent) {
            this.xram[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & Short.MAX_VALUE] = value;
        } else {
            this.vram[address] = value;
        }
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            if (this.chrRamPresent) {
                return this.xram[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & Short.MAX_VALUE];
            }
            return this.chrROM[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRomSizeMask];
        }
        return this.vram[address];
    }

    @Override
    public void update() {
        if (this.irqEnabled) {
            this.irqCounter = this.irqCounter + 1 & 0xFFFF;
            if (this.irqCounter == 0) {
                this.cpu.setMapperIrq(true);
                this.irqEnabled = false;
            }
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        switch (address) {
            case 17150: {
                this.ffeAltMode = !BitUtil.getBitBool(value, 7);
                this.setNametableMirroring(2 + BitUtil.getBit(value, 4));
                break;
            }
            case 17151: {
                this.setNametableMirroring(BitUtil.getBit(value, 4));
                break;
            }
            case 17665: {
                this.irqEnabled = false;
                this.cpu.setMapperIrq(false);
                break;
            }
            case 17666: {
                this.irqCounter = this.irqCounter & 0xFF00 | value;
                this.cpu.setMapperIrq(false);
                break;
            }
            case 17667: {
                this.irqCounter = this.irqCounter & 0xFF | value << 8;
                this.irqEnabled = true;
                this.cpu.setMapperIrq(false);
            }
        }
        super.writeMemory(address, value);
    }
}

