/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.daouinfosys;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.mappers.konami.vrc7.VRC7Audio;
import nintaco.util.BitUtil;

public class Mapper515
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final VRC7Audio audio = new VRC7Audio();
    private int adcData;

    public Mapper515(CartFile cartFile) {
        super(cartFile, 4, 1);
        this.audio.init();
    }

    @Override
    public void init() {
        this.setPrgBank(3, -1);
    }

    private int readMicrophone() {
        return 0;
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xE003) == 24579) {
            int value = this.adcData & 0x80;
            this.adcData <<= 1;
            this.adcData &= 0xFF;
            return value;
        }
        return super.readMemory(address);
    }

    private void write6(int address, int value) {
        switch (address & 1) {
            case 0: {
                this.audio.writeRegister(36880, value);
                break;
            }
            case 1: {
                this.audio.writeRegister(36912, value);
            }
        }
    }

    private void write8(int value) {
        int bank = value & 0x3F;
        if (BitUtil.getBitBool(value, 7)) {
            bank -= 64;
        }
        this.setPrgBank(2, bank);
    }

    private void writeC(int address) {
        if ((address & 3) == 2) {
            this.adcData = (int)((double)this.readMicrophone() * 64.0);
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        switch (address & 0xE000) {
            case 24576: {
                this.write6(address, value);
                break;
            }
            case 32768: {
                this.write8(value);
                break;
            }
            case 49152: {
                this.writeC(address);
            }
        }
    }

    @Override
    public void update() {
        this.audio.update();
    }

    @Override
    public int getAudioMixerScale() {
        return 0;
    }

    @Override
    public float getAudioSample() {
        return this.audio.getAudioSample();
    }
}

