/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.codemasters;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class BF909x
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean bf9097Mode;

    public BF909x(CartFile cartFile) {
        super(cartFile, 4, 1);
        if (cartFile.getSubmapperNumber() == 1) {
            this.bf9097Mode = true;
        }
    }

    @Override
    public void init() {
        this.setPrgBank(2, 0);
        this.setPrgBank(3, -1);
        this.setChrBank(0);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address == 36864) {
            this.bf9097Mode = true;
        }
        if (address >= 49152 || !this.bf9097Mode) {
            this.setPrgBank(2, value);
        } else if (address < 49152) {
            this.setNametableMirroring(2 + BitUtil.getBit(value, 4));
        }
    }
}

