/*
 * Decompiled with CFR 0.152.
 */
package nintaco.logger;

import java.io.File;
import java.io.PrintStream;
import java.util.logging.FileHandler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import nintaco.files.FileUtil;
import nintaco.logger.LogFormatter;
import nintaco.logger.LogOutputStream;
import nintaco.logger.StdOutErrLevel;

public final class LogUtil {
    private static final String LOG_OFF = "-log=off";

    private LogUtil() {
    }

    public static void init(String ... args) throws Throwable {
        for (String arg : args) {
            if (!LOG_OFF.equalsIgnoreCase(arg)) continue;
            return;
        }
        LogManager logManager = LogManager.getLogManager();
        logManager.reset();
        String systemDir = FileUtil.getWorkingDirectory("system");
        FileUtil.mkdir(systemDir);
        FileHandler fileHandler = new FileHandler(systemDir + File.separator + "nintaco-%g.log", 0x100000, 10, true);
        fileHandler.setFormatter(new LogFormatter());
        Logger.getLogger("").addHandler(fileHandler);
        System.setOut(new PrintStream(new LogOutputStream(Logger.getLogger("stdout"), StdOutErrLevel.STDOUT), true));
        System.setErr(new PrintStream(new LogOutputStream(Logger.getLogger("stderr"), StdOutErrLevel.STDERR), true));
    }
}

