/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.zapper;

import java.io.Serializable;
import nintaco.input.zapper.ZapperMapper;

public class VsZapperMapper
extends ZapperMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private int shiftRegister;
    private boolean strobe;

    public VsZapperMapper(int portIndex) {
        super(portIndex);
    }

    @Override
    protected void updatePortValue() {
        this.portValue = 16;
        if (this.trigger != 0) {
            this.portValue |= 0x80;
        }
        if (this.photoSensor != 0) {
            this.portValue |= 0x40;
        }
    }

    @Override
    public void writePort(int value) {
        boolean bl = this.strobe = (value & 1) == 1;
        if (this.strobe) {
            this.shiftRegister = this.portValue;
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (this.portIndex == portIndex) {
            int value = this.shiftRegister & 1;
            if (!this.strobe) {
                this.shiftRegister >>= 1;
            }
            return value;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return this.portIndex == portIndex ? this.shiftRegister & 1 : 0;
    }
}

