/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.turbofile;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.preferences.GamePrefs;
import nintaco.util.StreamUtil;

public class TurboFileMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int WRITE_BIT = 1;
    private static final int NO_RESET = 2;
    private static final int WRITE_ENABLE = 4;
    private static final int READ_BIT = 4;
    private transient int[] sram = new int[8192];
    private int address = 0;
    private int bit = 1;
    private int output;
    private boolean writeEnabled;

    public TurboFileMapper() {
        int[] turboFileRam = GamePrefs.getInstance().getStorageUnitRam();
        if (turboFileRam != null && turboFileRam.length == 8192) {
            this.sram = turboFileRam;
        }
    }

    @Override
    public int getInputDevice() {
        return 34;
    }

    @Override
    public void update(int buttons) {
    }

    @Override
    public void writePort(int value) {
        if ((value & 2) == 0) {
            this.address = 0;
            this.bit = 1;
        }
        boolean advance = this.writeEnabled;
        boolean bl = this.writeEnabled = (value & 4) != 0;
        if (this.writeEnabled) {
            int n = this.address;
            this.sram[n] = this.sram[n] & ~this.bit;
            if ((value & 1) != 0) {
                int n2 = this.address;
                this.sram[n2] = this.sram[n2] | this.bit;
            }
        } else if (advance) {
            if (this.bit != 128) {
                this.bit <<= 1;
            } else {
                this.bit = 1;
                this.address = this.address + 1 & 0x1FFF;
            }
        }
        this.output = (this.sram[this.address] & this.bit) != 0 ? 4 : 0;
    }

    @Override
    public int readPort(int portIndex) {
        return portIndex == 1 ? this.output : 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return this.readPort(portIndex);
    }

    @Override
    public void close(boolean saveNonVolatileData) {
        if (saveNonVolatileData) {
            GamePrefs.getInstance().setStorageUnitRam(this.sram);
            GamePrefs.save();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.sram = StreamUtil.readSparseByteArray(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        StreamUtil.writeSparseByteArray(out, this.sram);
    }
}

