/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.racermate;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;
import nintaco.util.BitUtil;
import nintaco.util.MathUtil;

public class RacerMateMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final float AVERAGE_PEDAL_WEIGHT = 0.0625f;
    private static final float MAX_PEDAL_TIME = 30.0f;
    private static final float PEDAL_COEFFICIENT = 0.001f;
    private static final float WIND_COEFFICIENT = 0.01010101f;
    private static final float DRAG_COEFFICIENT = 0.007f;
    private static final float GRADE_COEFFICIENT = 5.3333333E-6f;
    private static final float FRICTION_COEFFICIENT = 7.142857E-7f;
    private static final float WATTS_SCALE = 7.142857f;
    private final int shift;
    private final int portIndex;
    private int buttons;
    private int out;
    private int writeValue;
    private int readValue;
    private int reads;
    private int readIndex;
    private int grade;
    private int wind;
    private int weight;
    private int pedalTimer = 30;
    private float averagePedalTime = 30.0f;
    private float speed;
    private boolean leftPedalActive;
    private boolean leftPedalPressed;
    private boolean rightPedalPressed;
    private ReceiveType receiveType = ReceiveType.SPEED;

    public RacerMateMapper(int portIndex) {
        this.shift = portIndex << 3;
        this.portIndex = portIndex;
    }

    private void write(int index, int data) {
        switch (index) {
            case 1: 
            case 2: {
                if (data >= 2048) {
                    data |= 0xFFFFF000;
                }
                if (index == 1) {
                    this.grade = data;
                    break;
                }
                this.wind = data;
                break;
            }
            case 3: {
                this.weight = data;
                break;
            }
            case 4: 
            case 5: {
                data -= 2048;
            }
        }
    }

    @Override
    public int getInputDevice() {
        return 27;
    }

    @Override
    public void update(int buttons) {
        int keys = (buttons = buttons >> this.shift & 0xFF) & 0x3F;
        if (keys == 0) {
            this.buttons = 128;
        } else {
            this.buttons = 1;
            while ((keys & 1) == 0) {
                keys >>= 1;
                this.buttons <<= 1;
            }
        }
        this.leftPedalPressed = BitUtil.getBitBool(buttons, 7);
        this.rightPedalPressed = BitUtil.getBitBool(buttons, 6);
        this.updateSpeed();
    }

    private void updateSpeed() {
        if (this.leftPedalActive) {
            if (this.rightPedalPressed && !this.leftPedalPressed) {
                this.leftPedalActive = false;
                this.pedalTimer = 0;
            } else {
                ++this.pedalTimer;
            }
        } else if (this.leftPedalPressed && !this.rightPedalPressed) {
            this.leftPedalActive = true;
            this.pedalTimer = 0;
        } else {
            ++this.pedalTimer;
        }
        this.averagePedalTime = 0.0625f * (float)this.pedalTimer + 0.9375f * this.averagePedalTime;
        if (this.averagePedalTime > 30.0f) {
            this.averagePedalTime = 30.0f;
        }
        this.speed += 0.001f * (1.0f - this.averagePedalTime / 30.0f);
        float windSpeed = this.speed + 0.01010101f * (float)this.wind;
        float drag = 0.007f * windSpeed * windSpeed;
        this.speed = windSpeed < 0.0f ? (this.speed += drag) : (this.speed -= drag);
        this.speed -= 5.3333333E-6f * (float)this.grade;
        this.speed -= 7.142857E-7f * (float)this.weight;
        if (this.speed > 1.0f) {
            this.speed = 1.0f;
        } else if (this.speed < 1.0E-6f) {
            this.speed = 0.0f;
        }
    }

    @Override
    public void writePort(int value) {
        this.out = value;
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 0) {
            if (this.reads >= 24 && (this.out == 187 || this.out == 238 || this.out == 51 || this.out == 204)) {
                this.reads = 0;
                if ((this.out & 1) == 0) {
                    this.write(BitUtil.reverseBits(this.writeValue >> 1 & 0xF) >> 4, BitUtil.reverseBits(this.writeValue >> 5 & 0x7F) << 4 | BitUtil.reverseBits(this.writeValue >> 13 + this.portIndex & 0x1F) >> 3);
                    this.readIndex = 0;
                    this.writeValue = 0;
                    switch (this.receiveType) {
                        case SPEED: {
                            this.receiveType = ReceiveType.WATTS;
                            this.readValue = 0x100000 | (int)(4095.0f * this.speed) << 8 | this.buttons;
                            break;
                        }
                        case WATTS: {
                            this.receiveType = ReceiveType.PULSE;
                            this.readValue = 0x200000 | Math.min(4095, (int)(7.142857f * this.speed * (float)this.weight)) << 8 | this.buttons;
                            break;
                        }
                        case PULSE: {
                            this.receiveType = ReceiveType.RPM;
                            this.readValue = 0x1300000 | MathUtil.clamp((int)(450.0f * this.speed), 60, 255) << 8 | this.buttons;
                            break;
                        }
                        case RPM: {
                            this.receiveType = ReceiveType.SPEED;
                            this.readValue = 0x680000 | (int)(255.0f * this.speed) << 8 | this.buttons;
                        }
                    }
                } else {
                    this.readIndex = 24;
                }
                this.readIndex -= this.portIndex;
                return 0;
            }
            ++this.reads;
        }
        if (this.portIndex == portIndex) {
            int b = this.readValue >> (this.readIndex >> 1) & 1;
            if ((this.readIndex & 1) == 0) {
                b ^= 1;
            }
            if (this.readIndex < 48 && (this.readIndex & 1) == 1) {
                this.writeValue = this.writeValue << 1 | this.out & 1;
            }
            ++this.readIndex;
            return b;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        if (this.portIndex == portIndex) {
            int b = this.readValue >> (this.readIndex >> 1) & 1;
            if ((this.readIndex & 1) == 0) {
                b ^= 1;
            }
            return b;
        }
        return 0;
    }

    @Override
    public void render(int[] screen) {
        int x = this.portIndex == 0 ? 16 : 136;
        int y = 12;
        InputIcons.RacerMate.render(screen, x, 12);
        if (BitUtil.getBitBool(this.buttons, 0)) {
            InputIcons.RacerMateButton.render(screen, x + 36, 44);
        }
        if (BitUtil.getBitBool(this.buttons, 1)) {
            InputIcons.RacerMateButton.render(screen, x + 36, 49);
        }
        if (BitUtil.getBitBool(this.buttons, 2)) {
            InputIcons.RacerMateButton.render(screen, x + 47, 49);
        }
        if (BitUtil.getBitBool(this.buttons, 3)) {
            InputIcons.RacerMateButton.render(screen, x + 58, 44);
        }
        if (BitUtil.getBitBool(this.buttons, 4)) {
            InputIcons.RacerMateButton.render(screen, x + 47, 44);
        }
        if (BitUtil.getBitBool(this.buttons, 5)) {
            InputIcons.RacerMateButton.render(screen, x + 58, 49);
        }
        if (this.leftPedalPressed) {
            InputIcons.RacerMateLeftPedal.render(screen, x + 1, 27);
        }
        if (this.rightPedalPressed) {
            InputIcons.RacerMateRightPedal.render(screen, x + 73, 27);
        }
    }

    private static enum ReceiveType {
        SPEED,
        WATTS,
        PULSE,
        RPM;

    }
}

