/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.racermate;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;

public abstract class RacerMateDescriptor
extends DeviceDescriptor {
    public static final int LeftPedal = 0;
    public static final int RightPedal = 1;
    public static final int F1 = 2;
    public static final int F2 = 3;
    public static final int F3 = 4;
    public static final int Plus = 5;
    public static final int Minus = 6;
    public static final int Reset = 7;
    public static final int RewindTime = 8;
    public static final int HighSpeed = 9;

    public RacerMateDescriptor(int inputDevice) {
        super(inputDevice);
    }

    @Override
    public int getButtonCount() {
        return 10;
    }

    @Override
    public int getRewindTimeButton() {
        return 8;
    }

    @Override
    public int getHighSpeedButton() {
        return 9;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                return "Left Pedal";
            }
            case 1: {
                return "Right Pedal";
            }
            case 2: {
                return "F1 / Start";
            }
            case 3: {
                return "F2 / Display";
            }
            case 4: {
                return "F3 / Set";
            }
            case 5: {
                return "+";
            }
            case 6: {
                return "-";
            }
            case 7: {
                return "Reset / Stop";
            }
            case 8: {
                return "Rewind Time";
            }
            case 9: {
                return "High Speed";
            }
        }
        return "Unknown";
    }

    protected ButtonMapping getDefaultButtonMapping(int buttonIndex, Component.Identifier[] defaults) {
        return this.getDefaultButtonMapping(InputUtil.getDefaultKeyboard(), buttonIndex, defaults);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        this.updateRewindTime(pressedValues[8] != 0, portIndex);
        this.updateHighSpeed(pressedValues[9] != 0, portIndex);
        int buttons = 0;
        if (pressedValues[0] != 0) {
            buttons |= 0x80;
        }
        if (pressedValues[1] != 0) {
            buttons |= 0x40;
        }
        if (pressedValues[6] != 0) {
            buttons |= 0x20;
        }
        if (pressedValues[3] != 0) {
            buttons |= 0x10;
        }
        if (pressedValues[5] != 0) {
            buttons |= 8;
        }
        if (pressedValues[4] != 0) {
            buttons |= 4;
        }
        if (pressedValues[2] != 0) {
            buttons |= 2;
        }
        if (pressedValues[7] != 0) {
            buttons |= 1;
        }
        return bits | buttons << (portIndex << 3);
    }
}

