/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.powerpad;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;
import nintaco.util.BitUtil;

public class PowerPadMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final int portIndex;
    private int buttons;
    private int shiftRegister;

    public PowerPadMapper(int portIndex) {
        this.portIndex = portIndex;
    }

    @Override
    public int getInputDevice() {
        return 26;
    }

    @Override
    public void update(int buttons) {
        this.buttons = buttons;
    }

    @Override
    public void writePort(int value) {
        if (BitUtil.getBitBool(value, 0)) {
            this.shiftRegister = this.buttons >> 11;
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (this.portIndex == portIndex) {
            this.shiftRegister >>= 2;
            return this.shiftRegister & 0x18;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return this.portIndex == portIndex ? this.shiftRegister & 0x18 : 0;
    }

    @Override
    public void render(int[] screen) {
        int x = (this.portIndex << 6) + 20;
        int y = 205;
        InputIcons.PowerPad.render(screen, x, 205);
        if ((this.buttons & 0x40000) != 0) {
            InputIcons.GamepadAB.render(screen, x + 2, 207);
        }
        if ((this.buttons & 0x10000) != 0) {
            InputIcons.GamepadAB.render(screen, x + 7, 207);
        }
        if ((this.buttons & 0x80000) != 0) {
            InputIcons.GamepadAB.render(screen, x + 13, 207);
        }
        if ((this.buttons & 0x20000) != 0) {
            InputIcons.GamepadAB.render(screen, x + 18, 207);
        }
        if ((this.buttons & 0x100000) != 0) {
            InputIcons.GamepadAB.render(screen, x + 2, 213);
        }
        if ((this.buttons & 0x1000000) != 0) {
            InputIcons.GamepadAB.render(screen, x + 7, 213);
        }
        if ((this.buttons & 0x40000000) != 0) {
            InputIcons.GamepadAB.render(screen, x + 13, 213);
        }
        if ((this.buttons & 0x800000) != 0) {
            InputIcons.GamepadAB.render(screen, x + 18, 213);
        }
        if ((this.buttons & 0x400000) != 0) {
            InputIcons.GamepadAB.render(screen, x + 2, 219);
        }
        if ((this.buttons & 0x4000000) != 0) {
            InputIcons.GamepadAB.render(screen, x + 7, 219);
        }
        if ((this.buttons & 0x10000000) != 0) {
            InputIcons.GamepadAB.render(screen, x + 13, 219);
        }
        if ((this.buttons & 0x200000) != 0) {
            InputIcons.GamepadAB.render(screen, x + 18, 219);
        }
    }
}

