/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.powerpad;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;

public class PowerPadDescriptor
extends DeviceDescriptor {
    public static final int SideB1 = 0;
    public static final int SideB2 = 1;
    public static final int SideB3 = 2;
    public static final int SideB4 = 3;
    public static final int SideB5 = 4;
    public static final int SideB6 = 5;
    public static final int SideB7 = 6;
    public static final int SideB8 = 7;
    public static final int SideB9 = 8;
    public static final int SideB10 = 9;
    public static final int SideB11 = 10;
    public static final int SideB12 = 11;
    public static final int SideA3 = 12;
    public static final int SideA2 = 13;
    public static final int SideA8 = 14;
    public static final int SideA7 = 15;
    public static final int SideA6 = 16;
    public static final int SideA5 = 17;
    public static final int SideA11 = 18;
    public static final int SideA10 = 19;
    public static final int RewindTime = 20;
    private static final Component.Identifier.Key[] DEFAULTS = new Component.Identifier.Key[]{Component.Identifier.Key.Q, Component.Identifier.Key.W, Component.Identifier.Key.E, Component.Identifier.Key.R, Component.Identifier.Key.A, Component.Identifier.Key.S, Component.Identifier.Key.D, Component.Identifier.Key.F, Component.Identifier.Key.Z, Component.Identifier.Key.X, Component.Identifier.Key.C, Component.Identifier.Key.V, Component.Identifier.Key.Y, Component.Identifier.Key.U, Component.Identifier.Key.G, Component.Identifier.Key.H, Component.Identifier.Key.J, Component.Identifier.Key.K, Component.Identifier.Key.N, Component.Identifier.Key.M, Component.Identifier.Key.EQUALS};

    public PowerPadDescriptor() {
        super(26);
    }

    @Override
    public String getDeviceName() {
        return "Power Pad";
    }

    @Override
    public int getButtonCount() {
        return 21;
    }

    @Override
    public int getRewindTimeButton() {
        return 20;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                return "Side B 1";
            }
            case 1: {
                return "Side B 2";
            }
            case 2: {
                return "Side B 3";
            }
            case 3: {
                return "Side B 4";
            }
            case 4: {
                return "Side B 5";
            }
            case 5: {
                return "Side B 6";
            }
            case 6: {
                return "Side B 7";
            }
            case 7: {
                return "Side B 8";
            }
            case 8: {
                return "Side B 9";
            }
            case 9: {
                return "Side B 10";
            }
            case 10: {
                return "Side B 11";
            }
            case 11: {
                return "Side B 12";
            }
            case 12: {
                return "Side A 3";
            }
            case 13: {
                return "Side A 2";
            }
            case 14: {
                return "Side A 8";
            }
            case 15: {
                return "Side A 7";
            }
            case 16: {
                return "Side A 6";
            }
            case 17: {
                return "Side A 5";
            }
            case 18: {
                return "Side A 11";
            }
            case 19: {
                return "Side A 10";
            }
            case 20: {
                return "Rewind Time";
            }
        }
        return "Unknown";
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(InputUtil.getDefaultKeyboard(), buttonIndex, (Component.Identifier[])DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        this.updateRewindTime(pressedValues[20] != 0, portIndex);
        if (pressedValues[1] != 0 || pressedValues[13] != 0) {
            bits |= 0x10000;
        }
        if (pressedValues[3] != 0) {
            bits |= 0x20000;
        }
        if (pressedValues[0] != 0) {
            bits |= 0x40000;
        }
        if (pressedValues[2] != 0 || pressedValues[12] != 0) {
            bits |= 0x80000;
        }
        if (pressedValues[4] != 0 || pressedValues[17] != 0) {
            bits |= 0x100000;
        }
        if (pressedValues[11] != 0) {
            bits |= 0x200000;
        }
        if (pressedValues[8] != 0) {
            bits |= 0x400000;
        }
        if (pressedValues[7] != 0 || pressedValues[14] != 0) {
            bits |= 0x800000;
        }
        if (pressedValues[5] != 0 || pressedValues[16] != 0) {
            bits |= 0x1000000;
        }
        bits |= 0x2000000;
        if (pressedValues[9] != 0 || pressedValues[19] != 0) {
            bits |= 0x4000000;
        }
        bits |= 0x8000000;
        if (pressedValues[10] != 0 || pressedValues[18] != 0) {
            bits |= 0x10000000;
        }
        bits |= 0x20000000;
        if (pressedValues[6] != 0 || pressedValues[15] != 0) {
            bits |= 0x40000000;
        }
        return bits |= Integer.MIN_VALUE;
    }
}

