/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.partytap;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;
import nintaco.util.BitUtil;

public class PartyTapMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private int mode = 224;
    private int buttons;
    private int shiftRegister;
    private boolean strobe;

    @Override
    public int getInputDevice() {
        return 24;
    }

    @Override
    public void update(int buttons) {
        this.buttons = buttons >> 14 & 0xFC;
    }

    @Override
    public void writePort(int value) {
        this.mode = 0xA0 | (value & 4) << 4;
        boolean priorStrobe = this.strobe;
        this.strobe = BitUtil.getBitBool(value, 0);
        if (priorStrobe && !this.strobe) {
            this.shiftRegister = this.buttons;
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 1) {
            int value = this.shiftRegister & 0x1C;
            this.shiftRegister = this.shiftRegister >> 3 | this.mode;
            return value;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return portIndex == 1 ? this.shiftRegister & 0x1C : 0;
    }

    @Override
    public void render(int[] screen) {
        int x = 128;
        int y = 208;
        int b = this.buttons >> 2;
        int i = 0;
        while (i < 6) {
            int X = 128 + 21 * i;
            InputIcons.PartyTap.render(screen, X, 208);
            if (BitUtil.getBitBool(b, 0)) {
                InputIcons.PartyTapButton.render(screen, X + 2, 210);
            }
            ++i;
            b >>= 1;
        }
    }
}

