/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.partytap;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;

public class PartyTapDescriptor
extends DeviceDescriptor {
    public static final int Unit1 = 0;
    public static final int Unit2 = 1;
    public static final int Unit3 = 2;
    public static final int Unit4 = 3;
    public static final int Unit5 = 4;
    public static final int Unit6 = 5;
    public static final int RewindTime = 6;
    private static final Component.Identifier.Key[] DEFAULTS = new Component.Identifier.Key[]{Component.Identifier.Key.Q, Component.Identifier.Key.W, Component.Identifier.Key.E, Component.Identifier.Key.R, Component.Identifier.Key.T, Component.Identifier.Key.Y, Component.Identifier.Key.EQUALS};

    public PartyTapDescriptor() {
        super(24);
    }

    @Override
    public String getDeviceName() {
        return "Party Tap";
    }

    @Override
    public int getButtonCount() {
        return 7;
    }

    @Override
    public int getRewindTimeButton() {
        return 6;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                return "Unit 1";
            }
            case 1: {
                return "Unit 2";
            }
            case 2: {
                return "Unit 3";
            }
            case 3: {
                return "Unit 4";
            }
            case 4: {
                return "Unit 5";
            }
            case 5: {
                return "Unit 6";
            }
        }
        return "Unknown";
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(InputUtil.getDefaultKeyboard(), buttonIndex, (Component.Identifier[])DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        this.updateRewindTime(pressedValues[6] != 0, portIndex);
        int buttons = 0;
        if (pressedValues[5] != 0) {
            buttons |= 0x20;
        }
        if (pressedValues[4] != 0) {
            buttons |= 0x10;
        }
        if (pressedValues[3] != 0) {
            buttons |= 8;
        }
        if (pressedValues[2] != 0) {
            buttons |= 4;
        }
        if (pressedValues[1] != 0) {
            buttons |= 2;
        }
        if (pressedValues[0] != 0) {
            buttons |= 1;
        }
        return bits | buttons << 16;
    }
}

