/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.gamepad;

import java.io.Serializable;
import nintaco.input.gamepad.LagDeviceMapper;
import nintaco.input.icons.InputIcons;
import nintaco.util.BitUtil;

public class GamepadMapper
extends LagDeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final int shift;
    private final int portIndex;
    private int shiftRegister;
    private boolean strobe;

    public GamepadMapper(int portIndex) {
        this.shift = portIndex << 3;
        this.portIndex = portIndex;
    }

    public int getPortIndex() {
        return this.portIndex;
    }

    @Override
    public int getInputDevice() {
        return 0;
    }

    @Override
    public void writePort(int value) {
        boolean bl = this.strobe = (value & 1) == 1;
        if (this.strobe) {
            this.updateButtons();
            this.shiftRegister = 0xFFFFFF00 | this.buttons >> this.shift & 0xFF;
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (this.portIndex == portIndex) {
            int value = this.shiftRegister & 1;
            if (!this.strobe) {
                this.shiftRegister >>= 1;
            }
            return value;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return this.portIndex == portIndex ? this.shiftRegister & 1 : 0;
    }

    @Override
    public void render(int[] screen) {
        GamepadMapper.render(screen, this.portIndex, this.buttons >> this.shift & 0xFF);
    }

    public static void render(int[] screen, int portIndex, int buttons) {
        int x = 19 + 59 * portIndex;
        int y = 208;
        InputIcons.Gamepad.render(screen, x, 208);
        if (BitUtil.getBitBool(buttons, 0)) {
            InputIcons.GamepadAB.render(screen, x + 31, 217);
        }
        if (BitUtil.getBitBool(buttons, 1)) {
            InputIcons.GamepadAB.render(screen, x + 26, 217);
        }
        if (BitUtil.getBitBool(buttons, 2)) {
            InputIcons.GamepadStart.render(screen, x + 14, 218);
        }
        if (BitUtil.getBitBool(buttons, 3)) {
            InputIcons.GamepadStart.render(screen, x + 19, 218);
        }
        if (BitUtil.getBitBool(buttons, 4)) {
            InputIcons.GamepadDPad.render(screen, x + 5, 213);
        }
        if (BitUtil.getBitBool(buttons, 5)) {
            InputIcons.GamepadDPad.render(screen, x + 5, 219);
        }
        if (BitUtil.getBitBool(buttons, 6)) {
            InputIcons.GamepadDPad.render(screen, x + 2, 216);
        }
        if (BitUtil.getBitBool(buttons, 7)) {
            InputIcons.GamepadDPad.render(screen, x + 8, 216);
        }
    }
}

