/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.familybasic.keyboard;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;

public class KeyboardDescriptor
extends DeviceDescriptor {
    public static final int KeyA = 0;
    public static final int KeyB = 1;
    public static final int KeyC = 2;
    public static final int KeyD = 3;
    public static final int KeyE = 4;
    public static final int KeyF = 5;
    public static final int KeyG = 6;
    public static final int KeyH = 7;
    public static final int KeyI = 8;
    public static final int KeyJ = 9;
    public static final int KeyK = 10;
    public static final int KeyL = 11;
    public static final int KeyM = 12;
    public static final int KeyN = 13;
    public static final int KeyO = 14;
    public static final int KeyP = 15;
    public static final int KeyQ = 16;
    public static final int KeyR = 17;
    public static final int KeyS = 18;
    public static final int KeyT = 19;
    public static final int KeyU = 20;
    public static final int KeyV = 21;
    public static final int KeyW = 22;
    public static final int KeyX = 23;
    public static final int KeyY = 24;
    public static final int KeyZ = 25;
    public static final int Key0 = 26;
    public static final int Key1 = 27;
    public static final int Key2 = 28;
    public static final int Key3 = 29;
    public static final int Key4 = 30;
    public static final int Key5 = 31;
    public static final int Key6 = 32;
    public static final int Key7 = 33;
    public static final int Key8 = 34;
    public static final int Key9 = 35;
    public static final int KeyF1 = 36;
    public static final int KeyF2 = 37;
    public static final int KeyF3 = 38;
    public static final int KeyF4 = 39;
    public static final int KeyF5 = 40;
    public static final int KeyF6 = 41;
    public static final int KeyF7 = 42;
    public static final int KeyF8 = 43;
    public static final int KeyLeftBracket = 44;
    public static final int KeyRightBracket = 45;
    public static final int KeySemicolon = 46;
    public static final int KeyColon = 47;
    public static final int KeyComma = 48;
    public static final int KeyPeriod = 49;
    public static final int KeyAtSign = 50;
    public static final int KeyCaret = 51;
    public static final int KeyMinus = 52;
    public static final int KeyForwardSlash = 53;
    public static final int KeyUnderscore = 54;
    public static final int KeyYen = 55;
    public static final int KeyUp = 56;
    public static final int KeyDown = 57;
    public static final int KeyLeft = 58;
    public static final int KeyRight = 59;
    public static final int KeyReturn = 60;
    public static final int KeySpace = 61;
    public static final int KeyInsert = 62;
    public static final int KeyBackspace = 63;
    public static final int KeyHome = 64;
    public static final int KeyEscape = 65;
    public static final int KeyGraph = 66;
    public static final int KeyStop = 67;
    public static final int KeyLeftShift = 68;
    public static final int KeyRightShift = 69;
    public static final int KeyControl = 70;
    public static final int KeyKana = 71;
    public static final int RewindTime = 72;
    public static final String[] NAMES = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "[", "]", ";", ":", ",", ".", "@", "^", "-", "/", "_", "\u00a5", "Up", "Down", "Left", "Right", "Return", "Space", "Insert", "Backspace", "Home", "Escape", "Graph", "Stop", "Left Shift", "Right Shift", "Ctrl", "Kana", "Rewind Time"};
    private static final Component.Identifier.Key[] DEFAULTS = new Component.Identifier.Key[]{Component.Identifier.Key.A, Component.Identifier.Key.B, Component.Identifier.Key.C, Component.Identifier.Key.D, Component.Identifier.Key.E, Component.Identifier.Key.F, Component.Identifier.Key.G, Component.Identifier.Key.H, Component.Identifier.Key.I, Component.Identifier.Key.J, Component.Identifier.Key.K, Component.Identifier.Key.L, Component.Identifier.Key.M, Component.Identifier.Key.N, Component.Identifier.Key.O, Component.Identifier.Key.P, Component.Identifier.Key.Q, Component.Identifier.Key.R, Component.Identifier.Key.S, Component.Identifier.Key.T, Component.Identifier.Key.U, Component.Identifier.Key.V, Component.Identifier.Key.W, Component.Identifier.Key.X, Component.Identifier.Key.Y, Component.Identifier.Key.Z, Component.Identifier.Key._0, Component.Identifier.Key._1, Component.Identifier.Key._2, Component.Identifier.Key._3, Component.Identifier.Key._4, Component.Identifier.Key._5, Component.Identifier.Key._6, Component.Identifier.Key._7, Component.Identifier.Key._8, Component.Identifier.Key._9, Component.Identifier.Key.F1, Component.Identifier.Key.F2, Component.Identifier.Key.F3, Component.Identifier.Key.F4, Component.Identifier.Key.F5, Component.Identifier.Key.F6, Component.Identifier.Key.F7, Component.Identifier.Key.F8, Component.Identifier.Key.LBRACKET, Component.Identifier.Key.RBRACKET, Component.Identifier.Key.SEMICOLON, Component.Identifier.Key.APOSTROPHE, Component.Identifier.Key.COMMA, Component.Identifier.Key.PERIOD, Component.Identifier.Key.GRAVE, Component.Identifier.Key.EQUALS, Component.Identifier.Key.MINUS, Component.Identifier.Key.SLASH, Component.Identifier.Key.END, Component.Identifier.Key.BACKSLASH, Component.Identifier.Key.UP, Component.Identifier.Key.DOWN, Component.Identifier.Key.LEFT, Component.Identifier.Key.RIGHT, Component.Identifier.Key.RETURN, Component.Identifier.Key.SPACE, Component.Identifier.Key.INSERT, Component.Identifier.Key.BACK, Component.Identifier.Key.HOME, Component.Identifier.Key.ESCAPE, Component.Identifier.Key.TAB, Component.Identifier.Key.PAUSE, Component.Identifier.Key.LSHIFT, Component.Identifier.Key.RSHIFT, Component.Identifier.Key.LCONTROL, Component.Identifier.Key.RCONTROL, Component.Identifier.Key.DELETE};
    public static final int[] KEY_MAP = new int[72];

    public KeyboardDescriptor() {
        super(18);
    }

    @Override
    public String getDeviceName() {
        return "Family Keyboard and Recorder";
    }

    @Override
    public int getButtonCount() {
        return 73;
    }

    @Override
    public int getRewindTimeButton() {
        return 72;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        return NAMES[buttonIndex];
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(InputUtil.getDefaultKeyboard(), buttonIndex, (Component.Identifier[])DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        this.updateRewindTime(pressedValues[72] != 0, portIndex);
        if (pressedValues[68] != 0) {
            bits |= 0x40000000;
        }
        if (pressedValues[69] != 0) {
            bits |= Integer.MIN_VALUE;
        }
        if (pressedValues[70] != 0) {
            bits |= 0x400;
        }
        if (pressedValues[71] != 0) {
            bits |= 0x800;
        }
        int pressed = 0;
        for (int i = 67; i >= 0; --i) {
            if (pressedValues[i] == 0) continue;
            if (pressed == 0) {
                bits |= KEY_MAP[i] << 16;
                ++pressed;
                continue;
            }
            bits |= KEY_MAP[i] << 23;
            ++pressed;
            break;
        }
        if (pressed == 0) {
            bits |= 0x3FFF0000;
        } else if (pressed == 1) {
            bits |= 0x3F800000;
        }
        return bits;
    }

    public void setKanaEnabled(int[] pressedValues, boolean kanaEnabled) {
        pressedValues[70] = 1;
        pressedValues[kanaEnabled ? 21 : 22] = 1;
    }

    public void pressKey(int[] pressedValues, char c) {
        switch (c) {
            case 'A': 
            case 'a': {
                pressedValues[0] = 1;
                break;
            }
            case 'B': 
            case 'b': {
                pressedValues[1] = 1;
                break;
            }
            case 'C': 
            case 'c': {
                pressedValues[2] = 1;
                break;
            }
            case 'D': 
            case 'd': {
                pressedValues[3] = 1;
                break;
            }
            case 'E': 
            case 'e': {
                pressedValues[4] = 1;
                break;
            }
            case 'F': 
            case 'f': {
                pressedValues[5] = 1;
                break;
            }
            case 'G': 
            case 'g': {
                pressedValues[6] = 1;
                break;
            }
            case 'H': 
            case 'h': {
                pressedValues[7] = 1;
                break;
            }
            case 'I': 
            case 'i': {
                pressedValues[8] = 1;
                break;
            }
            case 'J': 
            case 'j': {
                pressedValues[9] = 1;
                break;
            }
            case 'K': 
            case 'k': {
                pressedValues[10] = 1;
                break;
            }
            case 'L': 
            case 'l': {
                pressedValues[11] = 1;
                break;
            }
            case 'M': 
            case 'm': {
                pressedValues[12] = 1;
                break;
            }
            case 'N': 
            case 'n': {
                pressedValues[13] = 1;
                break;
            }
            case 'O': 
            case 'o': {
                pressedValues[14] = 1;
                break;
            }
            case 'P': 
            case 'p': {
                pressedValues[15] = 1;
                break;
            }
            case 'Q': 
            case 'q': {
                pressedValues[16] = 1;
                break;
            }
            case 'R': 
            case 'r': {
                pressedValues[17] = 1;
                break;
            }
            case 'S': 
            case 's': {
                pressedValues[18] = 1;
                break;
            }
            case 'T': 
            case 't': {
                pressedValues[19] = 1;
                break;
            }
            case 'U': 
            case 'u': {
                pressedValues[20] = 1;
                break;
            }
            case 'V': 
            case 'v': {
                pressedValues[21] = 1;
                break;
            }
            case 'W': 
            case 'w': {
                pressedValues[22] = 1;
                break;
            }
            case 'X': 
            case 'x': {
                pressedValues[23] = 1;
                break;
            }
            case 'Y': 
            case 'y': {
                pressedValues[24] = 1;
                break;
            }
            case 'Z': 
            case 'z': {
                pressedValues[25] = 1;
                break;
            }
            case '0': {
                pressedValues[26] = 1;
                break;
            }
            case '1': {
                pressedValues[27] = 1;
                break;
            }
            case '2': {
                pressedValues[28] = 1;
                break;
            }
            case '3': {
                pressedValues[29] = 1;
                break;
            }
            case '4': {
                pressedValues[30] = 1;
                break;
            }
            case '5': {
                pressedValues[31] = 1;
                break;
            }
            case '6': {
                pressedValues[32] = 1;
                break;
            }
            case '7': {
                pressedValues[33] = 1;
                break;
            }
            case '8': {
                pressedValues[34] = 1;
                break;
            }
            case '9': {
                pressedValues[35] = 1;
                break;
            }
            case '[': {
                pressedValues[44] = 1;
                break;
            }
            case ']': {
                pressedValues[45] = 1;
                break;
            }
            case ';': {
                pressedValues[46] = 1;
                break;
            }
            case ':': 
            case '\uff1a': {
                pressedValues[47] = 1;
                break;
            }
            case ',': {
                pressedValues[48] = 1;
                break;
            }
            case '.': {
                pressedValues[49] = 1;
                break;
            }
            case '@': {
                pressedValues[50] = 1;
                break;
            }
            case '^': {
                pressedValues[51] = 1;
                break;
            }
            case '-': {
                pressedValues[52] = 1;
                break;
            }
            case '/': {
                pressedValues[53] = 1;
                break;
            }
            case '_': {
                pressedValues[54] = 1;
                break;
            }
            case '\\': {
                pressedValues[55] = 1;
                break;
            }
            case '\n': {
                pressedValues[60] = 1;
                break;
            }
            case ' ': {
                pressedValues[61] = 1;
                break;
            }
            case '!': {
                pressedValues[68] = 1;
                pressedValues[27] = 1;
                break;
            }
            case '\"': {
                pressedValues[68] = 1;
                pressedValues[28] = 1;
                break;
            }
            case '#': {
                pressedValues[68] = 1;
                pressedValues[29] = 1;
                break;
            }
            case '$': {
                pressedValues[68] = 1;
                pressedValues[30] = 1;
                break;
            }
            case '%': {
                pressedValues[68] = 1;
                pressedValues[31] = 1;
                break;
            }
            case '&': {
                pressedValues[68] = 1;
                pressedValues[32] = 1;
                break;
            }
            case '\'': {
                pressedValues[68] = 1;
                pressedValues[33] = 1;
                break;
            }
            case '(': {
                pressedValues[68] = 1;
                pressedValues[34] = 1;
                break;
            }
            case ')': {
                pressedValues[68] = 1;
                pressedValues[35] = 1;
                break;
            }
            case '=': {
                pressedValues[68] = 1;
                pressedValues[52] = 1;
                break;
            }
            case '+': {
                pressedValues[68] = 1;
                pressedValues[46] = 1;
                break;
            }
            case '*': {
                pressedValues[68] = 1;
                pressedValues[47] = 1;
                break;
            }
            case '<': {
                pressedValues[68] = 1;
                pressedValues[48] = 1;
                break;
            }
            case '>': {
                pressedValues[68] = 1;
                pressedValues[49] = 1;
                break;
            }
            case '?': {
                pressedValues[68] = 1;
                pressedValues[53] = 1;
                break;
            }
            case '\u30a2': {
                pressedValues[27] = 1;
                break;
            }
            case '\u30a4': {
                pressedValues[28] = 1;
                break;
            }
            case '\u30a6': {
                pressedValues[29] = 1;
                break;
            }
            case '\u30a8': {
                pressedValues[30] = 1;
                break;
            }
            case '\u30aa': {
                pressedValues[31] = 1;
                break;
            }
            case '\u30ca': {
                pressedValues[32] = 1;
                break;
            }
            case '\u30cb': {
                pressedValues[33] = 1;
                break;
            }
            case '\u30cc': {
                pressedValues[34] = 1;
                break;
            }
            case '\u30cd': {
                pressedValues[35] = 1;
                break;
            }
            case '\u30ce': {
                pressedValues[26] = 1;
                break;
            }
            case '\u30e9': {
                pressedValues[52] = 1;
                break;
            }
            case '\u30ea': {
                pressedValues[51] = 1;
                break;
            }
            case '\u30eb': {
                pressedValues[55] = 1;
                break;
            }
            case '\u30ab': {
                pressedValues[16] = 1;
                break;
            }
            case '\u30ad': {
                pressedValues[22] = 1;
                break;
            }
            case '\u30af': {
                pressedValues[4] = 1;
                break;
            }
            case '\u30b1': {
                pressedValues[17] = 1;
                break;
            }
            case '\u30b3': {
                pressedValues[19] = 1;
                break;
            }
            case '\u30cf': {
                pressedValues[24] = 1;
                break;
            }
            case '\u30d2': {
                pressedValues[20] = 1;
                break;
            }
            case '\u30d5': {
                pressedValues[8] = 1;
                break;
            }
            case '\u30d8': {
                pressedValues[14] = 1;
                break;
            }
            case '\u30db': {
                pressedValues[15] = 1;
                break;
            }
            case '\u30ec': {
                pressedValues[50] = 1;
                break;
            }
            case '\u30ed': {
                pressedValues[44] = 1;
                break;
            }
            case '\u30b5': {
                pressedValues[0] = 1;
                break;
            }
            case '\u30b7': {
                pressedValues[18] = 1;
                break;
            }
            case '\u30b9': {
                pressedValues[3] = 1;
                break;
            }
            case '\u30bb': {
                pressedValues[5] = 1;
                break;
            }
            case '\u30bd': {
                pressedValues[6] = 1;
                break;
            }
            case '\u30de': {
                pressedValues[7] = 1;
                break;
            }
            case '\u30df': {
                pressedValues[9] = 1;
                break;
            }
            case '\u30e0': {
                pressedValues[10] = 1;
                break;
            }
            case '\u30e1': {
                pressedValues[11] = 1;
                break;
            }
            case '\u30e2': {
                pressedValues[46] = 1;
                break;
            }
            case '\u30fc': {
                pressedValues[47] = 1;
                break;
            }
            case '\u3002': {
                pressedValues[45] = 1;
                break;
            }
            case '\u30bf': {
                pressedValues[25] = 1;
                break;
            }
            case '\u30c1': {
                pressedValues[23] = 1;
                break;
            }
            case '\u30c4': {
                pressedValues[2] = 1;
                break;
            }
            case '\u30c6': {
                pressedValues[21] = 1;
                break;
            }
            case '\u30c8': {
                pressedValues[1] = 1;
                break;
            }
            case '\u30e4': {
                pressedValues[13] = 1;
                break;
            }
            case '\u30e6': {
                pressedValues[12] = 1;
                break;
            }
            case '\u30e8': {
                pressedValues[48] = 1;
                break;
            }
            case '\u30ef': {
                pressedValues[49] = 1;
                break;
            }
            case '\u30f2': {
                pressedValues[53] = 1;
                break;
            }
            case '\u30f3': {
                pressedValues[54] = 1;
                break;
            }
            case '\u30a1': {
                pressedValues[68] = 1;
                pressedValues[27] = 1;
                break;
            }
            case '\u30a3': {
                pressedValues[68] = 1;
                pressedValues[28] = 1;
                break;
            }
            case '\u30a5': {
                pressedValues[68] = 1;
                pressedValues[29] = 1;
                break;
            }
            case '\u30a7': {
                pressedValues[68] = 1;
                pressedValues[30] = 1;
                break;
            }
            case '\u30a9': {
                pressedValues[68] = 1;
                pressedValues[31] = 1;
                break;
            }
            case '\u30d1': {
                pressedValues[68] = 1;
                pressedValues[24] = 1;
                break;
            }
            case '\u30d4': {
                pressedValues[68] = 1;
                pressedValues[20] = 1;
                break;
            }
            case '\u30d7': {
                pressedValues[68] = 1;
                pressedValues[8] = 1;
                break;
            }
            case '\u30da': {
                pressedValues[68] = 1;
                pressedValues[14] = 1;
                break;
            }
            case '\u30dd': {
                pressedValues[68] = 1;
                pressedValues[15] = 1;
                break;
            }
            case '\u300c': {
                pressedValues[68] = 1;
                pressedValues[44] = 1;
                break;
            }
            case '\u300d': {
                pressedValues[68] = 1;
                pressedValues[45] = 1;
                break;
            }
            case '\u2423': {
                pressedValues[68] = 1;
                pressedValues[54] = 1;
            }
        }
    }

    static {
        KeyboardDescriptor.KEY_MAP[43] = 0;
        KeyboardDescriptor.KEY_MAP[60] = 1;
        KeyboardDescriptor.KEY_MAP[44] = 2;
        KeyboardDescriptor.KEY_MAP[45] = 3;
        KeyboardDescriptor.KEY_MAP[71] = 4;
        KeyboardDescriptor.KEY_MAP[69] = 5;
        KeyboardDescriptor.KEY_MAP[55] = 6;
        KeyboardDescriptor.KEY_MAP[67] = 7;
        KeyboardDescriptor.KEY_MAP[42] = 8;
        KeyboardDescriptor.KEY_MAP[50] = 9;
        KeyboardDescriptor.KEY_MAP[47] = 10;
        KeyboardDescriptor.KEY_MAP[46] = 11;
        KeyboardDescriptor.KEY_MAP[54] = 12;
        KeyboardDescriptor.KEY_MAP[53] = 13;
        KeyboardDescriptor.KEY_MAP[52] = 14;
        KeyboardDescriptor.KEY_MAP[51] = 15;
        KeyboardDescriptor.KEY_MAP[41] = 16;
        KeyboardDescriptor.KEY_MAP[14] = 17;
        KeyboardDescriptor.KEY_MAP[11] = 18;
        KeyboardDescriptor.KEY_MAP[10] = 19;
        KeyboardDescriptor.KEY_MAP[49] = 20;
        KeyboardDescriptor.KEY_MAP[48] = 21;
        KeyboardDescriptor.KEY_MAP[15] = 22;
        KeyboardDescriptor.KEY_MAP[26] = 23;
        KeyboardDescriptor.KEY_MAP[40] = 24;
        KeyboardDescriptor.KEY_MAP[8] = 25;
        KeyboardDescriptor.KEY_MAP[20] = 26;
        KeyboardDescriptor.KEY_MAP[9] = 27;
        KeyboardDescriptor.KEY_MAP[12] = 28;
        KeyboardDescriptor.KEY_MAP[13] = 29;
        KeyboardDescriptor.KEY_MAP[35] = 30;
        KeyboardDescriptor.KEY_MAP[34] = 31;
        KeyboardDescriptor.KEY_MAP[39] = 32;
        KeyboardDescriptor.KEY_MAP[24] = 33;
        KeyboardDescriptor.KEY_MAP[6] = 34;
        KeyboardDescriptor.KEY_MAP[7] = 35;
        KeyboardDescriptor.KEY_MAP[1] = 36;
        KeyboardDescriptor.KEY_MAP[21] = 37;
        KeyboardDescriptor.KEY_MAP[33] = 38;
        KeyboardDescriptor.KEY_MAP[32] = 39;
        KeyboardDescriptor.KEY_MAP[38] = 40;
        KeyboardDescriptor.KEY_MAP[19] = 41;
        KeyboardDescriptor.KEY_MAP[17] = 42;
        KeyboardDescriptor.KEY_MAP[3] = 43;
        KeyboardDescriptor.KEY_MAP[5] = 44;
        KeyboardDescriptor.KEY_MAP[2] = 45;
        KeyboardDescriptor.KEY_MAP[31] = 46;
        KeyboardDescriptor.KEY_MAP[30] = 47;
        KeyboardDescriptor.KEY_MAP[37] = 48;
        KeyboardDescriptor.KEY_MAP[22] = 49;
        KeyboardDescriptor.KEY_MAP[18] = 50;
        KeyboardDescriptor.KEY_MAP[0] = 51;
        KeyboardDescriptor.KEY_MAP[23] = 52;
        KeyboardDescriptor.KEY_MAP[25] = 53;
        KeyboardDescriptor.KEY_MAP[4] = 54;
        KeyboardDescriptor.KEY_MAP[29] = 55;
        KeyboardDescriptor.KEY_MAP[36] = 56;
        KeyboardDescriptor.KEY_MAP[65] = 57;
        KeyboardDescriptor.KEY_MAP[16] = 58;
        KeyboardDescriptor.KEY_MAP[70] = 59;
        KeyboardDescriptor.KEY_MAP[68] = 60;
        KeyboardDescriptor.KEY_MAP[66] = 61;
        KeyboardDescriptor.KEY_MAP[27] = 62;
        KeyboardDescriptor.KEY_MAP[28] = 63;
        KeyboardDescriptor.KEY_MAP[64] = 64;
        KeyboardDescriptor.KEY_MAP[56] = 65;
        KeyboardDescriptor.KEY_MAP[59] = 66;
        KeyboardDescriptor.KEY_MAP[58] = 67;
        KeyboardDescriptor.KEY_MAP[57] = 68;
        KeyboardDescriptor.KEY_MAP[61] = 69;
        KeyboardDescriptor.KEY_MAP[63] = 70;
        KeyboardDescriptor.KEY_MAP[62] = 71;
    }
}

